/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import juzu.Scope;
import juzu.impl.inject.spi.InjectManager;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.CDIManager;
import juzu.impl.inject.spi.cdi.Container;
import juzu.impl.inject.spi.cdi.ContextImpl;
import juzu.impl.inject.spi.cdi.SingletonBean;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImpl
implements Extension {
    private static final AnnotationLiteral<Produces> PRODUCES_ANNOTATION_LITERAL = new AnnotationLiteral<Produces>(){};
    private final CDIManager manager = CDIManager.boot.get();
    private List<Bean<?>> singletons = new ArrayList();

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        boolean veto;
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class type = annotatedType.getJavaClass();
        boolean bound = false;
        for (AbstractBean boundBean : this.manager.boundBeans) {
            if (!boundBean.getBeanClass().isAssignableFrom(type)) continue;
            bound = true;
        }
        boolean bl = veto = bound || this.manager.filter != null && !this.manager.filter.acceptBean(type);
        if (veto) {
            pat.veto();
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        Container container = Container.boot.get();
        for (Scope scope : container.scopes) {
            if (scope.isBuiltIn()) continue;
            event.addContext((Context)new ContextImpl(container.scopeController, scope, scope.getAnnotationType()));
        }
        event.addBean((Bean)new SingletonBean(InjectManager.class, Tools.set(AbstractBean.DEFAULT_QUALIFIER, AbstractBean.ANY_QUALIFIER), this.manager));
        for (AbstractBean bean : this.manager.boundBeans) {
            bean.register(beanManager);
            event.addBean((Bean)bean);
        }
    }

    void processBean(@Observes ProcessBean event, BeanManager beanManager) {
        Bean bean = event.getBean();
        this.manager.beans.add(bean);
        if (bean.getScope() == Singleton.class) {
            this.singletons.add(bean);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
        for (Bean<?> singleton : this.singletons) {
            CreationalContext cc = beanManager.createCreationalContext(singleton);
            Object o = beanManager.getReference(singleton, (Type)singleton.getBeanClass(), cc);
            singleton.destroy(o, cc);
        }
    }
}

