/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import japa.parser.ASTHelper;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import juzu.Application;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import juzu.test.JavaFile;
import org.junit.Test;

public class ApplicationTestCase
extends AbstractTestCase {
    @Test
    public void testAdd() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("metamodel.application");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        ModuleMetaModel mm = (ModuleMetaModel)((MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser)).metaModel;
        List events = mm.getQueue().clear();
        ApplicationTestCase.assertEquals((int)1, (int)events.size());
        ApplicationTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(0)).getType());
        ApplicationTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ApplicationMetaModel));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("handle", (Object)"ElementHandle.Package[qn=metamodel.application]").list("templates")}));
        ApplicationTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testUpdate() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("metamodel.application");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModelState b = (MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser);
        ModuleMetaModel mm = (ModuleMetaModel)b.metaModel;
        mm.getQueue().clear();
        Tools.serialize((Serializable)b, (File)ser);
        JavaFile<File> pkgFile = helper.assertSource("metamodel", "application", "package-info.java");
        PackageDeclaration pkg = pkgFile.assertPackage();
        pkg.getAnnotations().clear();
        List<NormalAnnotationExpr> a = Collections.singletonList(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)Application.class.getName()), Collections.singletonList(new MemberValuePair("name", (Expression)new StringLiteralExpr("abc")))));
        pkg.setAnnotations(a);
        pkgFile.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        mm = (ModuleMetaModel)((MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser)).metaModel;
        List events = mm.getQueue().clear();
        ApplicationTestCase.assertEquals((int)1, (int)events.size());
        ApplicationTestCase.assertEquals((int)2, (int)((MetaModelEvent)events.get(0)).getType());
        ApplicationTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ApplicationMetaModel));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("handle", (Object)"ElementHandle.Package[qn=metamodel.application]").list("templates")}));
        ApplicationTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testRemove() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("metamodel.application");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModelState unserialize = (MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser);
        ModuleMetaModel mm = (ModuleMetaModel)unserialize.metaModel;
        mm.getQueue().clear();
        Tools.serialize((Serializable)unserialize, (File)ser);
        ApplicationTestCase.assertTrue((boolean)((File)helper.getSourcePath().getPath(new String[]{"metamodel", "application", "package-info.java"})).delete());
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        mm = (ModuleMetaModel)((MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser)).metaModel;
        List events = mm.getQueue().clear();
        ApplicationTestCase.assertEquals((int)1, (int)events.size());
        ApplicationTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ApplicationTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ApplicationMetaModel));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values"));
        ApplicationTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testRemoveAnnotation() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("metamodel.application");
        helper.assertCompile();
        JavaFile<File> pkgFile = helper.assertSource("metamodel", "application", "package-info.java");
        PackageDeclaration pkg = pkgFile.assertPackage();
        pkg.getAnnotations().clear();
        pkgFile.assertSave();
        helper.assertCompile();
    }
}

