/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import jregex.Matcher;
import jregex.Pattern;
import juzu.impl.router.regex.RE;
import juzu.impl.router.regex.REFactory;

public class JRegexFactory
extends REFactory {
    public static final REFactory INSTANCE = new JRegexFactory();

    private JRegexFactory() {
    }

    public RE compile(String pattern) {
        return new JRegex(pattern);
    }

    public String getName() {
        return "jregex";
    }

    public static class JRegex
    extends RE {
        private final Pattern pattern;

        public JRegex(String regex) {
            this.pattern = new Pattern(regex);
        }

        public RE.Matcher matcher() {
            return new RE.Matcher(){
                private Matcher impl;

                private Matcher get(CharSequence seq) {
                    String s = ((Object)seq).toString();
                    if (this.impl == null) {
                        this.impl = JRegex.this.pattern.matcher(s);
                    } else {
                        this.impl.setTarget(s);
                    }
                    return this.impl;
                }

                public boolean matches(CharSequence s) {
                    return this.get(s).matches();
                }

                public RE.Match[] find(CharSequence s) {
                    Matcher matcher = this.get(s);
                    if (matcher.find()) {
                        RE.Match[] matches = new RE.Match[matcher.groupCount()];
                        for (int i = 0; i < matcher.groupCount(); ++i) {
                            matches[i] = matcher.isCaptured(i) ? new RE.Match(matcher.start(i), matcher.end(i), matcher.group(i)) : RE.NULL_MATCH;
                        }
                        return matches;
                    }
                    return RE.NO_MATCHES;
                }
            };
        }

        public String getPattern() {
            return this.pattern.toString();
        }
    }
}

