/*
 * Decompiled with CFR 0.152.
 */
package juzu.asset;

import juzu.asset.AssetLocation;

public abstract class Asset {
    public static Id ref(String id) {
        return new Id(id);
    }

    public static Value server(String uri) {
        return Asset.of(AssetLocation.SERVER, uri);
    }

    public static Value classpath(String uri) {
        return Asset.of(AssetLocation.CLASSPATH, uri);
    }

    public static Value url(String uri) {
        return Asset.of(AssetLocation.URL, uri);
    }

    public static Value of(AssetLocation location, String uri) {
        return new Value(location, uri);
    }

    public static class Id
    extends Asset {
        private final String value;

        private Id(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Value
    extends Asset {
        private final AssetLocation location;
        private final String uri;

        private Value(AssetLocation location, String uri) {
            this.location = location;
            this.uri = uri;
        }

        public AssetLocation getLocation() {
            return this.location;
        }

        public String getURI() {
            return this.uri;
        }
    }
}

