/*
 * Copyright (C) 2012 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package juzu.impl.bridge.spi;

import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;

import java.io.IOException;
import java.util.Map;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
public interface DispatchSPI {

  MethodHandle getTarget();

  Map<String, String[]> getParameters();

  /**
   * @param propertyType  the property type
   * @param propertyValue the property value
   * @param <T>           the property generic type
   * @return null when the property is valid, an error message otherwise
   */
  <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue);

  void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException;

}
