/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.Asset;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebMimeBridge;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Method;
import juzu.io.AppendableStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRenderBridge
extends WebMimeBridge
implements RenderBridge {
    private Response.Content response;
    private Iterable<Asset.Value> scripts;
    private Iterable<Asset.Value> stylesheets;
    private Map<String, String> responseMetaTags;
    private String title;

    WebRenderBridge(Application application, Handler handler, WebBridge http, Method<?> target, Map<String, String[]> parameters) {
        super(application, handler, http, target, parameters);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (response instanceof Response.Content) {
            try {
                PropertyMap properties = response.getProperties();
                Iterable<Map.Entry<String, String>> metaProps = properties.getValues(PropertyType.META_TAG);
                Iterable<Asset> scriptsProp = properties.getValues(PropertyType.SCRIPT);
                Iterable<Asset> stylesheetProps = properties.getValues(PropertyType.STYLESHEET);
                Map<String, String> metaTags = Collections.emptyMap();
                if (metaProps != null) {
                    for (Map.Entry<String, String> entry : metaProps) {
                        if (metaTags.isEmpty()) {
                            metaTags = new HashMap();
                        }
                        metaTags.put(entry.getKey(), entry.getValue());
                    }
                }
                Iterable<Object> stylesheets = Collections.emptyList();
                if (stylesheetProps != null) {
                    stylesheets = this.handler.getBridge().application.getStylesheetManager().resolveAssets(stylesheetProps);
                }
                Iterable<Object> scripts = Collections.emptyList();
                if (scriptsProp != null) {
                    scripts = this.handler.getBridge().application.getScriptManager().resolveAssets(scriptsProp);
                }
                this.scripts = scripts;
                this.stylesheets = stylesheets;
                this.responseMetaTags = metaTags;
            }
            catch (IllegalArgumentException e) {
                response = Response.content(500, e.getMessage());
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.response = (Response.Content)response;
    }

    private String getAssetURL(Asset.Value asset) throws IOException {
        StringBuilder url = new StringBuilder();
        String uri = asset.getURI();
        this.http.renderAssetURL(asset.getLocation(), uri, url);
        return url.toString();
    }

    @Override
    public void end() {
        super.end();
        ScopedContext context = this.http.getFlashScope(false);
        if (context != null) {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void send() throws IOException {
        if (this.response != null) {
            this.http.setContentType(this.response.getMimeType());
            Integer status = this.response.getStatus();
            if (status != null) {
                this.http.setStatus(status);
            }
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                this.http.setHeader((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            Writer writer = null;
            try {
                writer = this.http.getWriter();
                writer.append("<!DOCTYPE html>\n");
                writer.append("<html>\n");
                writer.append("<head>\n");
                if (this.title != null) {
                    writer.append("<title>");
                    writer.append(this.title);
                    writer.append("</title>\n");
                }
                for (Map.Entry<String, String> meta : this.responseMetaTags.entrySet()) {
                    writer.append("<meta name=\"");
                    writer.append(meta.getKey());
                    writer.append("\" content=\"");
                    writer.append(meta.getValue());
                    writer.append("\">\n");
                }
                for (Asset.Value stylesheet : this.stylesheets) {
                    String path = stylesheet.getURI();
                    int pos = path.lastIndexOf(46);
                    String ext = pos == -1 ? "css" : path.substring(pos + 1);
                    writer.append("<link rel=\"stylesheet\" type=\"text/");
                    writer.append(ext);
                    writer.append("\" href=\"");
                    writer.append(this.getAssetURL(stylesheet));
                    writer.append("\"></link>\n");
                }
                for (Asset.Value script : this.scripts) {
                    writer.append("<script type=\"text/javascript\" src=\"");
                    writer.append(this.getAssetURL(script));
                    writer.append("\"></script>\n");
                }
                writer.append("</head>\n");
                writer.append("<body>\n");
                this.response.send(new AppendableStream(writer));
                writer.append("</body>\n");
                writer.append("</html>\n");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                Tools.safeClose(writer);
                throw throwable;
            }
            Tools.safeClose(writer);
            {
            }
        }
    }
}

