/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import juzu.impl.common.JSON;
import juzu.impl.common.JSONParserConstants;
import juzu.impl.common.JSONParserTokenManager;
import juzu.impl.common.JavaCharStream;
import juzu.impl.common.ParseException;
import juzu.impl.common.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONParser
implements JSONParserConstants {
    public JSONParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;

    public final Object parse() throws ParseException {
        Serializable o = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                o = this.object();
                break;
            }
            case 15: {
                o = this.array();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return o;
    }

    public final JSON object() throws ParseException {
        JSON m = JSON.json();
        this.jj_consume_token(13);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: 
            case 32: {
                this.members(m);
                break;
            }
        }
        this.jj_consume_token(14);
        return m;
    }

    public final void members(JSON m) throws ParseException {
        this.pair(m);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.members(m);
                break;
            }
        }
    }

    public final void pair(JSON m) throws ParseException {
        Object t = null;
        String fieldName = null;
        fieldName = this.fieldName();
        this.jj_consume_token(18);
        Object o = this.value();
        m.set(fieldName, o);
    }

    public final String fieldName() throws ParseException {
        String fieldName = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                fieldName = this.stripOffQuotes(this.decodeBackslash(this.token.image));
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                fieldName = this.stripOffQuotes(this.decodeBackslash(this.token.image));
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                fieldName = this.decodeBackslash(this.token.image);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return fieldName;
    }

    String stripOffQuotes(String quotedString) throws ParseException {
        if (!quotedString.startsWith("\"") && !quotedString.startsWith("'")) {
            return quotedString;
        }
        return quotedString.substring(1, quotedString.length() - 1);
    }

    String decodeBackslash(String s) throws ParseException {
        StringBuilder sb = new StringBuilder();
        int inputLength = s.length();
        boolean isAfterSlash = false;
        for (int i = 0; i < inputLength; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (!isAfterSlash) {
                    isAfterSlash = true;
                    continue;
                }
                sb.append(c);
                isAfterSlash = false;
                continue;
            }
            if (isAfterSlash) {
                switch (c) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '/': {
                        sb.append('/');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'u': {
                        int u = Integer.parseInt(s.substring(i + 1, i + 5), 16);
                        sb.append((char)u);
                        i += 4;
                    }
                }
                isAfterSlash = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public final ArrayList<Object> array() throws ParseException {
        ArrayList<Object> a = new ArrayList<Object>();
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 25: 
            case 30: 
            case 31: {
                this.elements(a);
                break;
            }
        }
        this.jj_consume_token(16);
        Collections.reverse(a);
        return a;
    }

    public final void elements(List<Object> a) throws ParseException {
        Object o = null;
        o = this.value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.elements(a);
                break;
            }
        }
        a.add(o);
    }

    public final Object value() throws ParseException {
        Token t = null;
        Object o = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                o = this.object();
                break;
            }
            case 15: {
                o = this.array();
                break;
            }
            case 30: {
                t = this.jj_consume_token(30);
                o = this.stripOffQuotes(this.decodeBackslash(t.image));
                break;
            }
            case 31: {
                t = this.jj_consume_token(31);
                o = this.stripOffQuotes(this.decodeBackslash(t.image));
                break;
            }
            case 25: {
                t = this.jj_consume_token(25);
                try {
                    o = Integer.valueOf(t.image);
                }
                catch (NumberFormatException nfe1) {
                    try {
                        o = Long.valueOf(t.image);
                    }
                    catch (NumberFormatException nfe2) {
                        try {
                            o = Float.valueOf(t.image);
                        }
                        catch (NumberFormatException nfe3) {
                            try {
                                o = Double.valueOf(t.image);
                            }
                            catch (NumberFormatException nfe4) {
                                o = Double.NaN;
                            }
                        }
                    }
                }
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                o = Boolean.TRUE;
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                o = Boolean.TRUE;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return o;
    }

    public JSONParser(InputStream stream) {
        this(stream, null);
    }

    public JSONParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JSONParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public JSONParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JSONParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public JSONParser(JSONParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(JSONParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

