/*
 * Decompiled with CFR 0.152.
 */
package juzu;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.asset.Asset;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Tools;
import juzu.io.Stream;
import juzu.io.Streamable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    protected final PropertyMap properties;

    protected Response() {
        this.properties = new PropertyMap();
    }

    protected Response(PropertyMap properties) {
        this.properties = properties;
    }

    public <T> Response with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
        if (propertyType == null) {
            throw new NullPointerException("No null property type allowed");
        }
        this.properties.setValue(propertyType, propertyValue);
        return this;
    }

    public <T> Response without(PropertyType<T> propertyType) throws NullPointerException {
        return this.with(propertyType, null);
    }

    public Response with(PropertyType<Boolean> propertyType) throws NullPointerException {
        return this.with(propertyType, true);
    }

    public Response withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
        return this.with(propertyType, false);
    }

    public final PropertyMap getProperties() {
        return this.properties;
    }

    public Response withHeader(String name, String ... value) {
        Iterable<Map.Entry<String, String[]>> values = this.properties.getValues(PropertyType.HEADER);
        if (values != null) {
            for (Map.Entry<String, String[]> header : values) {
                if (!header.getKey().equals(name)) continue;
                header.setValue(value);
                return this;
            }
        }
        this.properties.addValue(PropertyType.HEADER, new AbstractMap.SimpleEntry<String, String[]>(name, value));
        return this;
    }

    public static Redirect redirect(String location) {
        return new Redirect(location);
    }

    public static Render ok(CharSequence content) {
        return Response.content(200, content);
    }

    public static Render notFound(CharSequence content) {
        return Response.content(404, content);
    }

    public static Render content(int code, CharSequence content) {
        return Response.content(code, new Streamable.CharSequence(content));
    }

    public static Render content(int code, Streamable<Stream.Char> content) {
        return new Render(code, content).withMimeType("text/html");
    }

    private static Render content(int code, String mimeType, CharSequence content) {
        return new Render(code, (Streamable<Stream.Char>)new Streamable.CharSequence(content)).withMimeType(mimeType);
    }

    public static Content<Stream.Binary> ok(InputStream content) {
        return Response.content(200, null, content);
    }

    public static Content<Stream.Binary> notFound(InputStream content) {
        return Response.content(404, null, content);
    }

    public static Content<Stream.Binary> content(int code, InputStream content) {
        return Response.content(code, null, content);
    }

    private static Content<Stream.Binary> content(int code, String mimeType, InputStream content) {
        return new Content<Stream.Binary>(code, Stream.Binary.class, new Streamable.InputStream(content)).withMimeType(mimeType);
    }

    public static Error error(Throwable t) {
        return new Error(t);
    }

    public static Error error(String msg) {
        return new Error(msg);
    }

    public static class Error
    extends Response {
        private final Throwable cause;
        private final String msg;

        public Error(Throwable cause) {
            this.cause = cause;
            this.msg = cause.getMessage();
        }

        public Error(String message) {
            this.cause = new Exception();
            this.msg = message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return "Response.Error[" + (this.cause != null ? this.cause.getMessage() : "") + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Render
    extends Content<Stream.Char> {
        @Override
        public <T> Render with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Render)super.with((PropertyType)propertyType, (Object)propertyValue);
        }

        @Override
        public <T> Render without(PropertyType<T> propertyType) throws NullPointerException {
            return (Render)super.without((PropertyType)propertyType);
        }

        @Override
        public Render with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Render)super.with((PropertyType)propertyType);
        }

        @Override
        public Render withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Render)super.withNo((PropertyType)propertyType);
        }

        public Render withMimeType(String mimeType) {
            return (Render)super.withMimeType(mimeType);
        }

        public Render() {
            super(200, Stream.Char.class);
        }

        public Render(int status, PropertyMap properties, Streamable<Stream.Char> streamable) {
            super(status, Stream.Char.class, properties, streamable);
        }

        public Render(int status, Streamable<Stream.Char> streamable) {
            super(status, Stream.Char.class, streamable);
        }

        public Render(PropertyMap properties, Streamable<Stream.Char> streamable) {
            super(200, Stream.Char.class, properties, streamable);
        }

        public Render(Streamable<Stream.Char> streamable) {
            super(200, Stream.Char.class, streamable);
        }

        @Override
        public Render withHeader(String name, String ... value) {
            return (Render)super.withHeader(name, value);
        }

        public String getTitle() {
            return this.properties.getValue(PropertyType.TITLE);
        }

        public Render withTitle(String title) {
            this.properties.setValue(PropertyType.TITLE, title);
            return this;
        }

        public Iterable<Asset> getScripts() {
            Iterable<Asset> scripts = this.properties.getValues(PropertyType.SCRIPT);
            return scripts != null ? scripts : Tools.emptyIterable();
        }

        public Render addScript(Asset script) throws NullPointerException {
            if (script == null) {
                throw new NullPointerException("No null script accepted");
            }
            this.properties.addValue(PropertyType.SCRIPT, script);
            return this;
        }

        public Iterable<Asset> getStylesheets() {
            Iterable<Asset> stylesheets = this.properties.getValues(PropertyType.STYLESHEET);
            return stylesheets != null ? stylesheets : Tools.emptyIterable();
        }

        public Render addStylesheet(Asset stylesheet) throws NullPointerException {
            if (stylesheet == null) {
                throw new NullPointerException("No null stylesheet accepted");
            }
            this.properties.addValue(PropertyType.SCRIPT, stylesheet);
            return this;
        }

        public Iterable<Map.Entry<String, String>> getMetaTags() {
            Iterable<Map.Entry<String, String>> metas = this.properties.getValues(PropertyType.META_TAG);
            return metas != null ? metas : Tools.emptyIterable();
        }

        public Render withMetaTag(String name, String value) {
            Iterable<Map.Entry<String, String>> values = this.properties.getValues(PropertyType.META_TAG);
            if (values != null) {
                for (Map.Entry<String, String> meta : values) {
                    if (!meta.getKey().equals(name)) continue;
                    meta.setValue(value);
                    return this;
                }
            }
            this.properties.addValue(PropertyType.META_TAG, new AbstractMap.SimpleEntry<String, String>(name, value));
            return this;
        }

        public String toString() {
            return "Response.Render[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Content<S extends Stream>
    extends Response {
        private int status;
        private final Class<S> kind;
        private Streamable<S> streamable;

        protected Content(int status, Class<S> kind) {
            this.status = status;
            this.kind = kind;
            this.streamable = null;
        }

        protected Content(int status, Class<S> kind, PropertyMap properties) {
            super(properties);
            this.status = status;
            this.kind = kind;
            this.streamable = null;
        }

        protected Content(int status, Class<S> kind, Streamable<S> streamable) {
            this.status = status;
            this.kind = kind;
            this.streamable = streamable;
        }

        protected Content(int status, Class<S> kind, PropertyMap properties, Streamable<S> streamable) {
            super(properties);
            this.status = status;
            this.kind = kind;
            this.streamable = streamable;
        }

        public Class<S> getKind() {
            return this.kind;
        }

        public Streamable<S> getStreamable() {
            return this.streamable;
        }

        public String getMimeType() {
            return this.properties.getValue(PropertyType.MIME_TYPE);
        }

        public Content<S> withMimeType(String mimeType) {
            this.properties.setValue(PropertyType.MIME_TYPE, mimeType);
            return this;
        }

        @Override
        public Content<S> withHeader(String name, String ... value) {
            return (Content)super.withHeader(name, value);
        }

        @Override
        public <T> Content<S> with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Content)super.with(propertyType, propertyValue);
        }

        @Override
        public <T> Content<S> without(PropertyType<T> propertyType) throws NullPointerException {
            return (Content)super.without(propertyType);
        }

        @Override
        public Content<S> with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Content)super.with(propertyType);
        }

        @Override
        public Content<S> withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Content)super.withNo(propertyType);
        }

        public Integer getStatus() {
            return this.status;
        }

        public void send(S stream) throws IOException {
            this.streamable.send(stream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Redirect
    extends Response {
        private final String location;

        public Redirect(String location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        @Override
        public <T> Redirect with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Redirect)super.with(propertyType, propertyValue);
        }

        @Override
        public Redirect withHeader(String name, String ... value) {
            return (Redirect)super.withHeader(name, value);
        }

        @Override
        public <T> Redirect without(PropertyType<T> propertyType) throws NullPointerException {
            return (Redirect)super.without(propertyType);
        }

        @Override
        public Redirect with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Redirect)super.with(propertyType);
        }

        @Override
        public Redirect withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Redirect)super.withNo(propertyType);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Redirect) {
                Redirect that = (Redirect)obj;
                return this.location.equals(that.location);
            }
            return false;
        }

        public String toString() {
            return "Response.Redirect[location" + this.location + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class View
    extends Response {
        public abstract MethodHandle getTarget();

        public abstract Map<String, String[]> getParameters();

        @Override
        public <T> View with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (View)super.with(propertyType, propertyValue);
        }

        @Override
        public View withHeader(String name, String ... value) {
            return (View)super.withHeader(name, value);
        }

        @Override
        public <T> View without(PropertyType<T> propertyType) throws NullPointerException {
            return (View)super.without(propertyType);
        }

        @Override
        public View with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (View)super.with(propertyType);
        }

        @Override
        public View withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (View)super.withNo(propertyType);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof View) {
                View that = (View)obj;
                return ((Object)this.getParameters()).equals(that.getParameters()) && this.properties.equals(that.properties);
            }
            return false;
        }

        public String toString() {
            return "Response.View[target=" + this.getTarget() + ",parameters" + this.getParameters() + ",properties=" + this.properties + "]";
        }
    }
}

