/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.DispatchSPI;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.portlet.PortletApplicationContext;
import juzu.impl.bridge.spi.portlet.PortletHttpContext;
import juzu.impl.bridge.spi.portlet.PortletSecurityContext;
import juzu.impl.bridge.spi.portlet.PortletUserContext;
import juzu.impl.bridge.spi.portlet.PortletWindowContext;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.Argument;
import juzu.impl.request.Method;
import juzu.impl.request.PhaseArgument;
import juzu.impl.request.Request;
import juzu.request.ApplicationContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.request.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletRequestBridge<Rq extends PortletRequest, Rs extends PortletResponse>
implements RequestBridge {
    protected final Application application;
    protected final Rq req;
    protected final Rs resp;
    protected final Method<?> target;
    protected final HashMap<String, Argument> arguments;
    protected final Map<String, String[]> parameters;
    protected final PortletHttpContext httpContext;
    protected final PortletSecurityContext securityContext;
    protected final PortletWindowContext windowContext;
    protected final PortletUserContext userContext;
    protected final PortletApplicationContext applicationContext;
    protected Request request;
    protected final boolean prod;
    protected Response response;

    PortletRequestBridge(Application application, Rq req, Rs resp, PortletConfig config, boolean prod) {
        String methodId = null;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(req.getParameterMap());
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry parameter = i.next();
            String key = (String)parameter.getKey();
            if (!key.startsWith("juzu.")) continue;
            if (((String)parameter.getKey()).equals("juzu.op")) {
                methodId = ((String[])parameter.getValue())[0];
            }
            i.remove();
        }
        Phase phase = this.getPhase();
        ApplicationDescriptor descriptor = application.getDescriptor();
        ControllersDescriptor controllers = descriptor.getControllers();
        ControllerResolver<Method> resolver = controllers.getResolver();
        Method target = methodId != null ? resolver.resolveMethod(phase, methodId, parameters.keySet()) : resolver.resolve(phase, parameters.keySet());
        HashMap<String, PhaseArgument> arguments = new HashMap<String, PhaseArgument>(target.getArguments(parameters));
        this.application = application;
        this.req = req;
        this.resp = resp;
        this.target = target;
        this.arguments = arguments;
        this.parameters = parameters;
        this.httpContext = new PortletHttpContext((PortletRequest)req);
        this.securityContext = new PortletSecurityContext((PortletRequest)req);
        this.windowContext = new PortletWindowContext(this);
        this.userContext = new PortletUserContext((PortletRequest)req);
        this.applicationContext = new PortletApplicationContext(config);
        this.prod = prod;
    }

    PortletRequestBridge(Application application, Rq req, Rs resp, PortletConfig config, Method<?> target, Map<String, String[]> parameters, boolean prod) {
        HashMap<String, PhaseArgument> arguments = new HashMap<String, PhaseArgument>(target.getArguments(parameters));
        this.application = application;
        this.req = req;
        this.resp = resp;
        this.target = target;
        this.arguments = arguments;
        this.parameters = parameters;
        this.httpContext = new PortletHttpContext((PortletRequest)req);
        this.securityContext = new PortletSecurityContext((PortletRequest)req);
        this.windowContext = new PortletWindowContext(this);
        this.userContext = new PortletUserContext((PortletRequest)req);
        this.applicationContext = new PortletApplicationContext(config);
        this.prod = prod;
    }

    protected abstract Phase getPhase();

    @Override
    public Map<String, ? extends Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        PortletMode propertyValue = null;
        if (JuzuPortlet.PORTLET_MODE.equals(propertyType)) {
            propertyValue = this.req.getPortletMode();
        } else if (JuzuPortlet.WINDOW_STATE.equals(propertyType)) {
            propertyValue = this.req.getWindowState();
        }
        return propertyValue == null ? null : (T)propertyType.cast(propertyValue);
    }

    @Override
    public MethodHandle getTarget() {
        return this.target.getHandle();
    }

    @Override
    public final Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public final WindowContext getWindowContext() {
        return this.windowContext;
    }

    @Override
    public final UserContext getUserContext() {
        return this.userContext;
    }

    @Override
    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public final Scoped getRequestValue(Object key) {
        ScopedContext context = this.getRequestContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            ScopedContext context = this.getRequestContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getRequestContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getFlashValue(Object key) {
        ScopedContext context = this.getFlashContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setFlashValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getFlashContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getFlashContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getSessionValue(Object key) {
        ScopedContext context = this.getSessionContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setSessionValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getSessionContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getSessionContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getIdentityValue(Object key) {
        return null;
    }

    @Override
    public final void setIdentityValue(Object key, Scoped value) {
    }

    @Override
    public void purgeSession() {
        PortletSession session = this.req.getPortletSession(false);
        if (session != null) {
            for (String key : new HashSet(session.getAttributeMap().keySet())) {
                session.removeAttribute(key);
            }
        }
    }

    @Override
    public void close() {
    }

    protected final ScopedContext getRequestContext(boolean create) {
        ScopedContext context = (ScopedContext)this.req.getAttribute("juzu.request_scope");
        if (context == null && create) {
            context = new ScopedContext();
            this.req.setAttribute("juzu.request_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getFlashContext(boolean create) {
        ScopedContext context = null;
        PortletSession session = this.req.getPortletSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.flash_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.flash_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getSessionContext(boolean create) {
        ScopedContext context = null;
        PortletSession session = this.req.getPortletSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.session_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.session_scope", (Object)context);
        }
        return context;
    }

    @Override
    public final void setResponse(Response response) throws IllegalArgumentException, IOException {
        this.response = response;
    }

    @Override
    public void begin(Request request) {
        this.request = request;
    }

    @Override
    public void end() {
        this.request = null;
        ScopedContext context = this.getRequestContext(false);
        if (context != null) {
            context.close();
        }
    }

    public abstract void send() throws IOException, PortletException;

    protected void sendProperties() throws IOException {
        Iterable<Map.Entry<String, String[]>> headers = this.response.getProperties().getValues(PropertyType.HEADER);
        if (headers != null) {
            for (Map.Entry<String, String[]> entry : headers) {
                this.resp.addProperty(entry.getKey(), entry.getValue()[0]);
            }
        }
    }

    private <T> String _checkPropertyValidity(Phase phase, PropertyType<T> propertyType, T propertyValue) {
        if (propertyType == JuzuPortlet.PORTLET_MODE) {
            if (phase == Phase.RESOURCE) {
                return "Resource URL don't have portlet modes";
            }
            PortletMode portletMode = (PortletMode)propertyValue;
            Enumeration e = this.req.getPortalContext().getSupportedPortletModes();
            while (e.hasMoreElements()) {
                PortletMode next = (PortletMode)e.nextElement();
                if (!next.equals((Object)portletMode)) continue;
                return null;
            }
            return "Unsupported portlet mode " + portletMode;
        }
        if (propertyType == JuzuPortlet.WINDOW_STATE) {
            if (phase == Phase.RESOURCE) {
                return "Resource URL don't have windwo state";
            }
            WindowState windowState = (WindowState)propertyValue;
            Enumeration e = this.req.getPortalContext().getSupportedWindowStates();
            while (e.hasMoreElements()) {
                WindowState next = (WindowState)e.nextElement();
                if (!next.equals((Object)windowState)) continue;
                return null;
            }
            return "Unsupported window state " + windowState;
        }
        return null;
    }

    @Override
    public DispatchSPI createDispatch(final Phase phase, final MethodHandle target, final Map<String, String[]> parameters) throws NullPointerException, IllegalArgumentException {
        return new DispatchSPI(){

            @Override
            public MethodHandle getTarget() {
                return target;
            }

            @Override
            public Map<String, String[]> getParameters() {
                return parameters;
            }

            @Override
            public <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue) {
                return PortletRequestBridge.this._checkPropertyValidity(phase, propertyType, propertyValue);
            }

            @Override
            public void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException {
                if (PortletRequestBridge.this.resp instanceof MimeResponse) {
                    PortletURL url;
                    MimeResponse mimeResp = (MimeResponse)PortletRequestBridge.this.resp;
                    Method method = PortletRequestBridge.this.application.getDescriptor().getControllers().getMethodByHandle(target);
                    if (method.getPhase() == Phase.ACTION) {
                        url = mimeResp.createActionURL();
                    } else if (method.getPhase() == Phase.VIEW) {
                        url = mimeResp.createRenderURL();
                    } else if (method.getPhase() == Phase.RESOURCE) {
                        url = mimeResp.createResourceURL();
                    } else {
                        throw new AssertionError();
                    }
                    url.setParameters(parameters);
                    boolean escapeXML = false;
                    if (properties != null) {
                        WindowState windowStateProperty;
                        PortletMode portletModeProperty;
                        Boolean escapeXMLProperty = properties.getValue(PropertyType.ESCAPE_XML);
                        if (escapeXMLProperty != null && Boolean.TRUE.equals(escapeXMLProperty)) {
                            escapeXML = true;
                        }
                        if ((portletModeProperty = properties.getValue(JuzuPortlet.PORTLET_MODE)) != null) {
                            if (url instanceof PortletURL) {
                                try {
                                    url.setPortletMode(portletModeProperty);
                                }
                                catch (PortletModeException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                        if ((windowStateProperty = properties.getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                            if (url instanceof PortletURL) {
                                try {
                                    url.setWindowState(windowStateProperty);
                                }
                                catch (WindowStateException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                        url.setParameter("juzu.op", method.getId());
                    }
                    if (escapeXML) {
                        StringWriter writer = new StringWriter();
                        url.write((Writer)writer, true);
                        appendable.append(writer.toString());
                    } else {
                        appendable.append(url.toString());
                    }
                } else {
                    throw new IllegalStateException("Cannot render an URL during phase " + phase);
                }
            }
        };
    }

    public PortletRequest getPortletRequest() {
        return this.req;
    }

    public PortletResponse getPortletResponse() {
        return this.resp;
    }
}

