/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatting {
    public static void renderStyleSheet(Writer writer) throws IOException {
        URL cssURL = JuzuPortlet.class.getResource("juzu.css");
        String css = Tools.read(cssURL);
        css = css.replace("\"", "\\\"");
        css = css.replace("'", "\\'");
        css = css.replace("\n", "\\n");
        writer.append("<script type='text/javascript'>\n");
        writer.append("var styleElement = document.createElement('style');\n");
        writer.append("var css = '");
        writer.append(css);
        writer.append("';\n");
        writer.append("styleElement.type = 'text/css';\n");
        writer.append("if (styleElement.styleSheet) {;\n");
        writer.append("styleElement.styleSheet.cssText = css;\n");
        writer.append("} else {\n");
        writer.append("styleElement.appendChild(document.createTextNode(css));\n");
        writer.append("}\n");
        writer.append("document.getElementsByTagName(\"head\")[0].appendChild(styleElement);\n");
        writer.append("</script>\n");
    }

    public static void renderThrowable(Writer writer, Throwable t) throws IOException {
        StackTraceElement[] trace;
        int size = 0;
        for (StackTraceElement element : trace = t.getStackTrace()) {
            if (element.getClassName().equals(JuzuPortlet.class.getName())) break;
            ++size;
        }
        StackTraceElement[] ourTrace = new StackTraceElement[size];
        System.arraycopy(trace, 0, ourTrace, 0, ourTrace.length);
        t.setStackTrace(ourTrace);
        final AtomicBoolean open = new AtomicBoolean(false);
        PrintWriter formatter = new PrintWriter(writer){

            public void println(Object x) {
                if (open.get()) {
                    super.append("</ul></pre>");
                }
                super.append("<div class=\"juzu-message\">");
                super.append(String.valueOf(x));
                super.append("</div>");
                open.set(false);
            }

            public void println(String x) {
                if (!open.get()) {
                    super.append("<pre><ul>");
                    open.set(true);
                }
                super.append("<li><span>");
                super.append(x);
                super.append("</span></li>");
            }

            public void println() {
            }
        };
        writer.append("<div class=\"juzu\">");
        writer.append("<div class=\"juzu-box\">");
        t.printStackTrace(formatter);
        if (open.get()) {
            writer.append("</ul></pre>");
        }
        writer.append("</div>");
        writer.append("</div>");
    }

    public static void renderErrors(Writer writer, Iterable<CompilationError> errors) throws IOException {
        Formatting.renderStyleSheet(writer);
        writer.append("<div class=\"juzu\">");
        for (CompilationError error : errors) {
            writer.append("<div class=\"juzu-box\">");
            writer.append("<div class=\"juzu-message\">").append(error.getMessage()).append("</div>");
            File source = error.getSourceFile();
            if (source != null) {
                int line = error.getLocation().getLine();
                int from = line - 2;
                int to = line + 3;
                BufferedReader reader = new BufferedReader(new FileReader(source));
                int count = 1;
                writer.append("<pre><ol start=\"").append(String.valueOf(from)).append("\">");
                String s = reader.readLine();
                while (s != null) {
                    if (count >= from && count < to) {
                        if (count == line) {
                            writer.append("<li><span class=\"error\">").append(s).append("</span></li>");
                        } else {
                            writer.append("<li><span>").append(s).append("</span></li>");
                        }
                    }
                    ++count;
                    s = reader.readLine();
                }
                writer.append("</ol></pre>");
            }
            writer.append("</div>");
        }
        writer.append("</div>");
    }
}

