/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;
import juzu.impl.common.MimeType;
import juzu.impl.common.PercentCodec;

public final class URIWriter {
    private MimeType mimeType;
    private Appendable appendable;
    private boolean questionMarkDone;

    public URIWriter(Appendable appendable, MimeType mimeType) throws NullPointerException {
        if (appendable == null) {
            throw new NullPointerException("No null appendable accepted");
        }
        this.appendable = appendable;
        this.mimeType = mimeType;
    }

    public URIWriter(Appendable appendable) throws NullPointerException {
        this(appendable, null);
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public void append(char c) throws IOException {
        this.appendable.append(c);
    }

    public void append(String s) throws IOException {
        this.appendable.append(s);
    }

    public void appendSegment(char c) throws IllegalStateException, IOException {
        if (this.questionMarkDone) {
            throw new IllegalStateException("Query separator already written");
        }
        PercentCodec.PATH_SEGMENT.encode(c, this.appendable);
    }

    public void appendSegment(String s) throws NullPointerException, IllegalStateException, IOException {
        if (s == null) {
            throw new NullPointerException("No null path accepted");
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.appendSegment(c);
        }
    }

    public void appendQueryParameter(String parameterName, String paramaterValue) throws NullPointerException, IOException {
        if (parameterName == null) {
            throw new NullPointerException("No null parameter name accepted");
        }
        if (paramaterValue == null) {
            throw new NullPointerException("No null parameter value accepted");
        }
        MimeType mt = this.mimeType;
        if (mt == null) {
            mt = MimeType.XHTML;
        }
        this.appendable.append(this.questionMarkDone ? mt.amp : "?");
        PercentCodec.QUERY_PARAM.encode(parameterName, this.appendable);
        this.appendable.append('=');
        PercentCodec.QUERY_PARAM.encode(paramaterValue, this.appendable);
        this.questionMarkDone = true;
    }

    public void reset(Appendable appendable) {
        this.appendable = appendable;
        this.questionMarkDone = false;
    }
}

