/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.router.metamodel;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.lang.model.element.Element;
import juzu.Route;
import juzu.impl.common.JSON;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.MethodMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.PhaseParameterMetaModel;
import juzu.impl.plugin.router.metamodel.RouteMetaModel;
import juzu.impl.plugin.router.metamodel.RouterMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterApplicationMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public RouterApplicationMetaModelPlugin() {
        super("router");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Route.class);
    }

    private RouterMetaModel getRoutes(ApplicationMetaModel metaModel, boolean create) {
        RouterMetaModel routes = metaModel.getChild(RouterMetaModel.KEY);
        if (routes == null && create) {
            routes = new RouterMetaModel();
            metaModel.addChild(RouterMetaModel.KEY, routes);
        }
        return routes;
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (key.getElement() instanceof ElementHandle.Method) {
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).annotations.put(key.getElement(), added);
        } else if (key.getElement().equals(metaModel.getHandle())) {
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).packageRoute = (String)added.get("value");
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).packagePriority = (Integer)added.get("priority");
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (key.getElement() instanceof ElementHandle.Method) {
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).annotations.remove(key.getElement());
        } else if (key.getElement().equals(metaModel.getHandle())) {
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).packageRoute = null;
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).packagePriority = null;
        }
    }

    @Override
    public void postProcessEvents(ApplicationMetaModel metaModel) {
        ControllersMetaModel controllers;
        RouterMetaModel router = this.getRoutes(metaModel, false);
        if (router != null && (controllers = metaModel.getChild(ControllersMetaModel.KEY)) != null) {
            RouteMetaModel root = new RouteMetaModel(router.packageRoute != null ? router.packageRoute : null, router.packagePriority != null ? router.packagePriority : 0);
            for (ControllerMetaModel controller : controllers) {
                for (MethodMetaModel method : controller) {
                    String key;
                    AnnotationState annotation = router.annotations.get(method.getHandle());
                    if (annotation == null) continue;
                    String path = (String)annotation.get("value");
                    Integer priority = (Integer)annotation.get("priority");
                    HashMap<String, String> parameters = null;
                    for (ParameterMetaModel parameter : method.getParameters()) {
                        PhaseParameterMetaModel invocationParameter;
                        if (!(parameter instanceof PhaseParameterMetaModel) || (invocationParameter = (PhaseParameterMetaModel)parameter).getPattern() == null) continue;
                        if (parameters == null) {
                            parameters = new HashMap<String, String>();
                        }
                        parameters.put(invocationParameter.getName(), invocationParameter.getPattern());
                    }
                    RouteMetaModel route = root.addChild(priority != null ? priority : 0, path, parameters);
                    if (route.getTarget(key = method.getPhase().name()) != null) {
                        throw RouterMetaModel.ROUTER_DUPLICATE_ROUTE.failure((Element)metaModel.processingContext.get(method.getHandle()), path);
                    }
                    route.setTarget(key, method.getHandle().getMethodHandle().toString());
                }
            }
            router.root = root;
        }
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        RouterMetaModel router = this.getRoutes(application, false);
        return router != null && router.root != null ? router.root.toJSON() : null;
    }
}

