/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.Collections;
import juzu.impl.router.AbstractControllerTestCase;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteKind;
import juzu.impl.router.Router;
import juzu.impl.router.RouterAssert;
import org.junit.Test;

public class PathEncodingTestCase
extends AbstractControllerTestCase {
    @Test
    public void testSegment1() throws Exception {
    }

    @Test
    public void testSegment2() throws Exception {
    }

    @Test
    public void testSegment3() throws Exception {
    }

    @Test
    public void testParamDefaultForm() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)".+")));
        router.assertRoute(Collections.singletonMap("p", "/"), "/_");
        router.assertRoute(Collections.singletonMap("p", "_"), "/%5F");
        router.assertRoute(Collections.singletonMap("p", "_/"), "/%5F_");
        router.assertRoute(Collections.singletonMap("p", "/_"), "/_%5F");
        router.assertRoute(Collections.singletonMap("p", "?"), "/%3F");
        PathEncodingTestCase.assertEquals((String)"/_", (String)a.matches(Collections.singletonMap("p", "/")).render());
        PathEncodingTestCase.assertEquals((String)"/%5F", (String)a.matches(Collections.singletonMap("p", "_")).render());
        PathEncodingTestCase.assertEquals((String)"/%5F_", (String)a.matches(Collections.singletonMap("p", "_/")).render());
        PathEncodingTestCase.assertEquals((String)"/_%5F", (String)a.matches(Collections.singletonMap("p", "/_")).render());
        PathEncodingTestCase.assertEquals((String)"/%3F", (String)a.matches(Collections.singletonMap("p", "?")).render());
    }

    @Test
    public void testAlternativeSepartorEscape() throws Exception {
        RouterAssert router = new RouterAssert(':');
        Route a = router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)".+")));
        router.assertRoute(Collections.singletonMap("p", "/"), "/:");
        router.assertRoute(Collections.singletonMap("p", "_"), "/_");
        router.assertRoute(Collections.singletonMap("p", ":"), "/%3A");
        PathEncodingTestCase.assertEquals((String)"/:", (String)a.matches(Collections.singletonMap("p", "/")).render());
        PathEncodingTestCase.assertEquals((String)"/_", (String)a.matches(Collections.singletonMap("p", "_")).render());
        PathEncodingTestCase.assertEquals((String)"/%3A", (String)a.matches(Collections.singletonMap("p", ":")).render());
    }

    @Test
    public void testBug() throws Exception {
        Router router = new Router();
        Route a = router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)"[^_]+")));
        PathEncodingTestCase.assertNull((Object)router.route("/_"));
        PathEncodingTestCase.assertEquals((String)"/_", (String)a.matches(Collections.singletonMap("p", "/")).render());
        PathEncodingTestCase.assertNull((Object)router.route("/%5F"));
        PathEncodingTestCase.assertNull((Object)a.matches(Collections.singletonMap("p", "_")));
    }

    @Test
    public void testParamPreservePath() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)"[^/]+").preservePath(true)));
        router.assertRoute(Collections.singletonMap("p", "_"), "/_");
        PathEncodingTestCase.assertNull((Object)router.route("//"));
        PathEncodingTestCase.assertNull((Object)a.matches(Collections.singletonMap("p", "/")));
    }

    @Test
    public void testD() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{p}", RouteKind.MATCH_ANY, Collections.singletonMap("p", PathParam.matching((String)"/[a-z]+/[a-z]+/?")));
        router.assertRoute(Collections.singletonMap("p", "/platform/administrator"), "/_platform_administrator");
        router.assertRoute(Collections.singletonMap("p", "/platform/administrator"), "/_platform_administrator/");
        router.assertRoute(Collections.singletonMap("p", "/platform/administrator/"), "/_platform_administrator_");
        router.assertRoute(Collections.singletonMap("p", "/platform/administrator/"), "/_platform_administrator_/");
        PathEncodingTestCase.assertEquals((String)"/_platform_administrator", (String)a.matches(Collections.singletonMap("p", "/platform/administrator")).render());
        PathEncodingTestCase.assertEquals((String)"/_platform_administrator_", (String)a.matches(Collections.singletonMap("p", "/platform/administrator/")).render());
        PathEncodingTestCase.assertNull((Object)a.matches(Collections.singletonMap("p", "/platform/administrator//")));
    }

    @Test
    public void testWildcardPathParamWithPreservePath() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)".*").preservePath(true)));
        PathEncodingTestCase.assertEquals((String)"/", (String)a.matches(Collections.singletonMap("p", "")).render());
        PathEncodingTestCase.assertEquals((String)"//", (String)a.matches(Collections.singletonMap("p", "/")).render());
        PathEncodingTestCase.assertEquals((String)"/a", (String)a.matches(Collections.singletonMap("p", "a")).render());
        PathEncodingTestCase.assertEquals((String)"/a/b", (String)a.matches(Collections.singletonMap("p", "a/b")).render());
        router.assertRoute(Collections.singletonMap("p", ""), "/");
        router.assertRoute(Collections.singletonMap("p", "/"), "//");
        router.assertRoute(Collections.singletonMap("p", "a"), "/a");
        router.assertRoute(Collections.singletonMap("p", "a/b"), "/a/b");
    }

    @Test
    public void testWildcardParamPathWithDefaultForm() throws Exception {
        Router router = new Router();
        Route a = router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)".*")));
        PathEncodingTestCase.assertEquals((String)"/_", (String)a.matches(Collections.singletonMap("p", "/")).render());
    }
}

