/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ResourceResolver;
import juzu.test.protocol.mock.MockClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockApplication<P>
implements Closeable {
    final ClassLoader classLoader;
    private final ApplicationLifeCycle<P, ?> lifeCycle;

    public <L> MockApplication(ReadFileSystem<P> classes, ClassLoader classLoader, InjectorProvider implementation, Name name) throws Exception {
        Logger log = new Logger(){

            public void log(CharSequence msg) {
                System.out.println("[] " + msg);
            }

            public void log(CharSequence msg, Throwable t) {
                System.err.println("[] " + msg);
                t.printStackTrace(System.err);
            }
        };
        ModuleLifeCycle.Static module = new ModuleLifeCycle.Static(log, classLoader, classes);
        ApplicationLifeCycle lifeCycle = new ApplicationLifeCycle(log, (ModuleLifeCycle)module, implementation, name, classes, null, new ResourceResolver(){

            public URL resolve(String uri) {
                return null;
            }
        });
        this.classLoader = classLoader;
        this.lifeCycle = lifeCycle;
    }

    public MockApplication<P> init() throws Exception {
        this.lifeCycle.refresh();
        return this;
    }

    public ApplicationLifeCycle<P, ?> getLifeCycle() {
        return this.lifeCycle;
    }

    public Application getContext() {
        return this.lifeCycle.getApplication();
    }

    void invoke(RequestBridge bridge) throws ApplicationException {
        this.lifeCycle.getApplication().invoke(bridge);
    }

    public MockClient client() {
        return new MockClient(this);
    }

    @Override
    public void close() throws IOException {
        Tools.safeClose(this.lifeCycle);
    }
}

