/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import juzu.request.HttpContext;

public class MockHttpContext
implements HttpContext {
    private static final Pattern CONTEXT_PATH_PATTERN = Pattern.compile("(?:/.*[^/])?");
    private static final Pattern FQDN_PATTERN = Pattern.compile("([a-zA-Z]+(([\\w-]+)*[\\w]+)*)+(\\.[a-zA-Z]+(([\\w-]+)*[\\w]+)*)*");
    private ArrayList<Cookie> cookies = new ArrayList();
    private String scheme = "http";
    private int serverPort = 80;
    private String serverName = "localhost";
    private String contextPath = "";

    public String getMethod() {
        return "GET";
    }

    public Cookie[] getCookies() {
        Cookie[] c = new Cookie[this.cookies.size()];
        for (int i = 0; i < this.cookies.size(); ++i) {
            c[i] = (Cookie)this.cookies.get(i).clone();
        }
        return c;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add((Cookie)cookie.clone());
    }

    public void clearCookies() {
        this.cookies.clear();
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        if (scheme == null) {
            throw new NullPointerException("No null scheme value accepted");
        }
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            throw new IllegalArgumentException("Scheme " + scheme + " is not valid");
        }
        this.scheme = scheme;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        if (serverPort < 1) {
            throw new IllegalArgumentException("Port " + serverPort + " is not valid");
        }
        this.serverPort = serverPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        if (serverName == null) {
            throw new NullPointerException("No null server name accepted");
        }
        if (!FQDN_PATTERN.matcher(serverName).matches()) {
            throw new IllegalArgumentException("Illegal server name value " + serverName);
        }
        this.serverName = serverName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new NullPointerException("No null context path accepted");
        }
        if (!CONTEXT_PATH_PATTERN.matcher(contextPath).matches()) {
            throw new IllegalArgumentException("Illegal context path value " + contextPath);
        }
        this.contextPath = contextPath;
    }
}

