/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.metamodel.AnnotationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CaptureAnnotationProcessor
extends AbstractProcessor {
    final HashMap<ElementHandle<?>, HashMap<String, AnnotationState>> statesMap = new HashMap();
    final HashSet<String> annotationTypes = new HashSet();

    CaptureAnnotationProcessor() {
    }

    public CaptureAnnotationProcessor with(Class<? extends Annotation> annotationType) {
        this.annotationTypes.add(annotationType.getName());
        return this;
    }

    public AnnotationState get(ElementHandle<?> element, Class<?> annotationType) {
        HashMap<String, AnnotationState> annotations = this.statesMap.get(element);
        return annotations != null ? annotations.get(annotationType.getName()) : null;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.annotationTypes;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                ElementHandle key = ElementHandle.create((Element)element);
                HashMap<String, Object> states = this.statesMap.get(key);
                if (states == null) {
                    states = new HashMap();
                    this.statesMap.put(key, states);
                }
                states.put(((Object)typeElement.asType()).toString(), AnnotationState.get((Element)element, (TypeMirror)typeElement.asType()));
            }
        }
        return false;
    }
}

