/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs;

import java.io.IOException;
import java.util.Collections;
import juzu.impl.common.Content;
import juzu.impl.fs.Change;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class ScannerTestCase
extends AbstractTestCase {
    @Test
    public void testFoo() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        FileSystemScanner scanner = FileSystemScanner.createTimestamped((ReadFileSystem)fs);
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        String[] foo = fs.makePath(fs.getRoot(), "foo");
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        String[] bar = fs.makePath(foo, "bar.txt");
        fs.setContent(bar, new Content((CharSequence)""));
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.singletonMap("/foo/bar.txt", Change.ADD), (Object)scanner.scan());
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        fs.setContent(bar, new Content((CharSequence)"value"));
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.singletonMap("/foo/bar.txt", Change.UPDATE), (Object)scanner.scan());
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        fs.removePath(bar);
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.singletonMap("/foo/bar.txt", Change.REMOVE), (Object)scanner.scan());
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
    }

    @Test
    public void testIgnoreHiddenFile() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        FileSystemScanner scanner = FileSystemScanner.createTimestamped((ReadFileSystem)fs);
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        String[] foo = fs.makePath(fs.getRoot(), ".foo");
        fs.setContent(foo, new Content((CharSequence)""));
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
    }

    @Test
    public void testIgnoreHiddenDir() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        FileSystemScanner scanner = FileSystemScanner.createTimestamped((ReadFileSystem)fs);
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        String[] bar = fs.makePath(fs.makePath(fs.getRoot(), ".foo"), "bar.txt");
        fs.setContent(bar, new Content((CharSequence)""));
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
    }
}

