/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template;

import java.util.ConcurrentModificationException;
import javax.naming.AuthenticationException;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.application.ApplicationException;
import juzu.template.TemplateExecutionException;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import org.junit.Test;

public class ThrowableTestCase
extends AbstractInjectTestCase {
    public ThrowableTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testChecked() throws Exception {
        MockApplication<?> app = this.application("plugin.template.throwable.checked").init();
        MockClient client = app.client();
        try {
            client.render();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(AuthenticationException.class, ThrowableTestCase.assertInstanceOf(TemplateExecutionException.class, e.getCause()).getCause());
        }
    }

    @Test
    public void testRuntime() throws Exception {
        MockApplication<?> app = this.application("plugin.template.throwable.runtime").init();
        MockClient client = app.client();
        try {
            client.render();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(ConcurrentModificationException.class, ThrowableTestCase.assertInstanceOf(TemplateExecutionException.class, e.getCause()).getCause());
        }
    }

    @Test
    public void testError() throws Exception {
        MockApplication<?> app = this.application("plugin.template.throwable.error").init();
        MockClient client = app.client();
        try {
            client.render();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(UnknownError.class, e.getCause()).getCause();
        }
    }
}

