/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import juzu.UndeclaredIOException;
import juzu.impl.common.URIWriter;
import juzu.impl.router.AbstractControllerTestCase;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteMatchTestCase
extends AbstractControllerTestCase {
    private void assertMatch(String expected, Route route, Map<String, String> parameters) {
        RouteMatch match = route.matches(parameters);
        RouteMatchTestCase.assertNotNull((String)("Was expecting to match " + expected), (Object)match);
        StringBuilder sb = new StringBuilder();
        URIWriter writer = new URIWriter((Appendable)sb);
        try {
            match.render(writer);
            for (Map.Entry entry : match.getUnmatched().entrySet()) {
                writer.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    @Test
    public void testPath() {
        Router router = new Router();
        Route a = router.append("/a");
        RouteMatch match = a.matches(Collections.emptyMap());
        RouteMatchTestCase.assertNotNull((Object)match);
        this.assertMatch("/a?a=foo", a, Collections.singletonMap("a", "foo"));
    }

    @Test
    public void testPathParam() {
        Router router = new Router();
        Route a = router.append("/{a}");
        RouteMatchTestCase.assertNull((Object)a.matches(Collections.emptyMap()));
        this.assertMatch("/foo", a, Collections.singletonMap("a", "foo"));
    }
}

