/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import juzu.impl.common.TrimmingException;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class TrimmingExceptionTestCase
extends AbstractTestCase {
    @Test
    public void testEmpty() {
        try {
            TrimmingException.invoke((TrimmingException.Callback)new TrimmingException.Callback(){

                public void call() throws Exception {
                    throw new UnsupportedOperationException();
                }
            });
        }
        catch (TrimmingException e) {
            TrimmingExceptionTestCase.assertEquals((int)0, (int)e.getStackTrace().length);
            TrimmingExceptionTestCase.assertEquals(null, (Object)e.getCause());
        }
    }

    @Test
    public void testException() {
        try {
            TrimmingException.invoke((TrimmingException.Callback)new TrimmingException.Callback(){

                public void call() throws Exception {
                    throw TrimmingExceptionTestCase.this.bar();
                }
            });
        }
        catch (TrimmingException e) {
            TrimmingExceptionTestCase.assertEquals((int)1, (int)e.getStackTrace().length);
            StackTraceElement elt = e.getStackTrace()[0];
            TrimmingExceptionTestCase.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)elt.getClassName());
            TrimmingExceptionTestCase.assertEquals((String)"bar", (String)elt.getMethodName());
            TrimmingExceptionTestCase.assertEquals(null, (Object)e.getCause());
        }
    }

    @Test
    public void testCause() {
        try {
            TrimmingException.invoke((TrimmingException.Callback)new TrimmingException.Callback(){

                public void call() throws Exception {
                    throw TrimmingExceptionTestCase.this.foo();
                }
            });
        }
        catch (TrimmingException e) {
            TrimmingExceptionTestCase.assertEquals((int)1, (int)e.getStackTrace().length);
            StackTraceElement elt = e.getStackTrace()[0];
            TrimmingExceptionTestCase.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)elt.getClassName());
            TrimmingExceptionTestCase.assertEquals((String)"foo", (String)elt.getMethodName());
            Throwable cause = e.getCause();
            TrimmingExceptionTestCase.assertEquals((int)2, (int)cause.getStackTrace().length);
            elt = cause.getStackTrace()[0];
            TrimmingExceptionTestCase.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)elt.getClassName());
            TrimmingExceptionTestCase.assertEquals((String)"bar", (String)elt.getMethodName());
            elt = cause.getStackTrace()[1];
            TrimmingExceptionTestCase.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)elt.getClassName());
            TrimmingExceptionTestCase.assertEquals((String)"foo", (String)elt.getMethodName());
            TrimmingExceptionTestCase.assertEquals(null, (Object)cause.getCause());
        }
    }

    public Exception bar() {
        return new UnsupportedOperationException();
    }

    public Exception foo() {
        return new IllegalArgumentException(this.bar());
    }
}

