/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import juzu.impl.common.Cardinality;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.request.Method;
import juzu.impl.request.PhaseParameter;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class RenderMethodTestCase
extends AbstractTestCase {
    private Class<?> aClass;
    private ApplicationDescriptor descriptor;

    public void setUp() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.method.render");
        compiler.assertCompile();
        this.aClass = compiler.assertClass("plugin.controller.method.render.A");
        compiler.assertClass("plugin.controller.method.render.A_");
        Class<?> appClass = compiler.assertClass("plugin.controller.method.render.Application");
        this.descriptor = ApplicationDescriptor.create(appClass);
    }

    @Test
    public void testNoArg() throws Exception {
        Method cm = this.descriptor.getControllers().getMethod(this.aClass, "noArg", new Class[0]);
        RenderMethodTestCase.assertEquals((String)"noArg", (String)cm.getName());
        RenderMethodTestCase.assertEquals((Object)Phase.VIEW, (Object)cm.getPhase());
        RenderMethodTestCase.assertEquals(Collections.emptyList(), cm.getParameters());
    }

    @Test
    public void testStringArg() throws Exception {
        Method cm = this.descriptor.getControllers().getMethod(this.aClass, "oneArg", new Class[]{String.class});
        RenderMethodTestCase.assertEquals((String)"oneArg", (String)cm.getName());
        RenderMethodTestCase.assertEquals((Object)Phase.VIEW, (Object)cm.getPhase());
        RenderMethodTestCase.assertEquals(Arrays.asList(new PhaseParameter("foo", null, Cardinality.SINGLE)), cm.getParameters());
    }
}

