/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.util.ArrayList;
import java.util.List;
import juzu.Scope;
import juzu.impl.common.JSON;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.binding.BindingDescriptor;

public class BindingPlugin
extends ApplicationPlugin {
    public BindingPlugin() {
        super("binding");
    }

    public Descriptor init(ClassLoader loader, JSON config) throws Exception {
        if (config != null) {
            ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
            List<JSON> bindings = config.getList("bindings", JSON.class);
            for (JSON binding : bindings) {
                String value = binding.getString("value");
                String scope = binding.getString("scope");
                String implementation = binding.getString("implementation");
                Class<?> valueType = loader.loadClass(value);
                Class<?> implementationType = implementation != null ? loader.loadClass(implementation) : null;
                Scope beanScope = scope != null ? Scope.valueOf(scope.toUpperCase()) : null;
                BeanDescriptor bean = new BeanDescriptor(valueType, beanScope, null, implementationType);
                beans.add(bean);
            }
            return new BindingDescriptor(beans);
        }
        return null;
    }
}

