/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metadata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import juzu.impl.common.JSON;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.template.metadata.TemplateDescriptor;
import juzu.template.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatesDescriptor
extends Descriptor {
    private final List<TemplateDescriptor> templates;
    private final String packageName;
    private final ArrayList<BeanDescriptor> beans;

    public TemplatesDescriptor(ClassLoader loader, JSON config) throws Exception {
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        ArrayList<TemplateDescriptor> templates = new ArrayList<TemplateDescriptor>();
        for (String fqn : config.getList("templates", String.class)) {
            Class<?> clazz = loader.loadClass(fqn);
            Field f = clazz.getField("DESCRIPTOR");
            TemplateDescriptor descriptor = (TemplateDescriptor)f.get(null);
            templates.add(descriptor);
            beans.add(new BeanDescriptor(Template.class, null, null, descriptor.getType()));
        }
        String packageName = config.getString("package");
        this.templates = templates;
        this.packageName = packageName;
        this.beans = beans;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        return this.beans;
    }

    public List<TemplateDescriptor> getTemplates() {
        return this.templates;
    }

    public TemplateDescriptor getTemplate(String path) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        for (TemplateDescriptor template : this.templates) {
            if (!template.getPath().equals(path)) continue;
            return template;
        }
        return null;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

