/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.EventQueue;
import juzu.Response;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.portlet.PortletClientContext;
import juzu.impl.bridge.spi.portlet.PortletEventProducer;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.ContextualArgument;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Parameter;
import juzu.request.ClientContext;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletActionBridge
extends PortletRequestBridge<ActionRequest, ActionResponse>
implements ActionBridge {
    private final PortletClientContext clientContext;

    public PortletActionBridge(Application application, ActionRequest request, ActionResponse response, boolean prod) {
        super(application, request, response, prod);
        for (Parameter parameter : this.target.getParameters()) {
            ContextualParameter contextualParameter;
            if (!(parameter instanceof ContextualParameter) || !EventQueue.class.isAssignableFrom((contextualParameter = (ContextualParameter)parameter).getType())) continue;
            PortletEventProducer producer = new PortletEventProducer();
            this.arguments.put(contextualParameter.getName(), new ContextualArgument(contextualParameter, producer));
        }
        this.clientContext = new PortletClientContext((ClientDataRequest)request);
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    protected Phase getPhase() {
        return Phase.ACTION;
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (response instanceof Response.View) {
            WindowState windowState;
            Response.View update = (Response.View)response;
            for (Map.Entry<String, String[]> entry : update.getParameters().entrySet()) {
                ((ActionResponse)this.resp).setRenderParameter(entry.getKey(), entry.getValue());
            }
            Method method = this.application.getDescriptor().getControllers().getMethodByHandle(update.getTarget());
            ((ActionResponse)this.resp).setRenderParameter("juzu.op", method.getId());
            PortletMode portletMode = update.getProperties().getValue(JuzuPortlet.PORTLET_MODE);
            if (portletMode != null) {
                try {
                    ((ActionResponse)this.resp).setPortletMode(portletMode);
                }
                catch (PortletModeException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if ((windowState = update.getProperties().getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                try {
                    ((ActionResponse)this.resp).setWindowState(windowState);
                }
                catch (WindowStateException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (response instanceof Response.Redirect) {
            Response.Redirect redirect = (Response.Redirect)response;
            ((ActionResponse)this.resp).sendRedirect(redirect.getLocation());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

