/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.bridge.spi.DispatchSPI;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.servlet.Handler;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.impl.common.Tools;
import juzu.impl.common.URIWriter;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Argument;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.SecurityContext;
import juzu.request.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServletRequestBridge
implements RequestBridge,
HttpContext,
WindowContext,
ClientContext {
    final Application application;
    final Handler handler;
    final HttpServletRequest req;
    final HttpServletResponse resp;
    final Map<String, String[]> parameters;
    final Method<?> target;
    final Map<String, ? extends Argument> arguments;
    protected Request request;
    protected Map<String, String[]> responseHeaders;

    ServletRequestBridge(Application application, Handler handler, HttpServletRequest req, HttpServletResponse resp, Method<?> target, Map<String, String[]> parameters) {
        this.arguments = target.getArguments(parameters);
        this.application = application;
        this.target = target;
        this.handler = handler;
        this.req = req;
        this.resp = resp;
        this.parameters = parameters;
        this.request = null;
    }

    @Override
    public String getContentType() {
        return this.req.getContentType();
    }

    @Override
    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    @Override
    public int getContentLenth() {
        return this.req.getContentLength();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    @Override
    public String getMethod() {
        return this.req.getMethod();
    }

    @Override
    public MethodHandle getTarget() {
        return this.target.getHandle();
    }

    @Override
    public Map<String, ? extends Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    @Override
    public String getScheme() {
        return this.req.getScheme();
    }

    @Override
    public int getServerPort() {
        return this.req.getServerPort();
    }

    @Override
    public String getServerName() {
        return this.req.getServerName();
    }

    @Override
    public String getContextPath() {
        return this.req.getContextPath();
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        if (PropertyType.PATH.equals(propertyType)) {
            return propertyType.cast(this.req.getRequestURI());
        }
        return null;
    }

    @Override
    public final String getNamespace() {
        return "window_ns";
    }

    @Override
    public final String getId() {
        return "window_id";
    }

    @Override
    public final Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public final HttpContext getHttpContext() {
        return this;
    }

    @Override
    public final WindowContext getWindowContext() {
        return this;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return null;
    }

    @Override
    public final Scoped getRequestValue(Object key) {
        ScopedContext context = this.getRequestContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            ScopedContext context = this.getRequestContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getRequestContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getFlashValue(Object key) {
        ScopedContext context = this.getFlashContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setFlashValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getFlashContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getFlashContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getSessionValue(Object key) {
        ScopedContext context = this.getSessionContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setSessionValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getSessionContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getSessionContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getIdentityValue(Object key) {
        return null;
    }

    @Override
    public final void setIdentityValue(Object key, Scoped value) {
    }

    @Override
    public void purgeSession() {
        HttpSession session = this.req.getSession(false);
        if (session != null) {
            for (String key : Tools.list(session.getAttributeNames())) {
                session.removeAttribute(key);
            }
        }
    }

    @Override
    public final DispatchSPI createDispatch(Phase phase, final MethodHandle target, final Map<String, String[]> parameters) {
        Method method = this.application.getDescriptor().getControllers().getMethodByHandle(target);
        Route route = this.handler.routeMap.get(method.getHandle());
        if (route == null && this.application.getDescriptor().getControllers().getResolver().isIndex(method)) {
            route = this.handler.root;
        }
        if (route != null) {
            Map<String, String> params;
            if (parameters.isEmpty()) {
                params = Collections.emptyMap();
            } else {
                params = new HashMap<String, String>(parameters.size());
                for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                    params.put(entry.getKey(), entry.getValue()[0]);
                }
            }
            final RouteMatch match = route.matches(params);
            if (match != null) {
                return new DispatchSPI(){

                    @Override
                    public MethodHandle getTarget() {
                        return target;
                    }

                    @Override
                    public Map<String, String[]> getParameters() {
                        return parameters;
                    }

                    @Override
                    public <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue) {
                        return null;
                    }

                    @Override
                    public void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException {
                        appendable.append(ServletRequestBridge.this.req.getScheme());
                        appendable.append("://");
                        appendable.append(ServletRequestBridge.this.req.getServerName());
                        int port = ServletRequestBridge.this.req.getServerPort();
                        if (port != 80) {
                            appendable.append(':').append(Integer.toString(port));
                        }
                        appendable.append(ServletRequestBridge.this.req.getContextPath());
                        URIWriter writer = new URIWriter(appendable, mimeType);
                        match.render(writer);
                        for (Map.Entry<String, String> entry : match.getUnmatched().entrySet()) {
                            String[] values;
                            for (String value : values = (String[])parameters.get(entry.getKey())) {
                                writer.appendQueryParameter(entry.getKey(), value);
                            }
                        }
                    }
                };
            }
            StringBuilder msg = new StringBuilder("The parameters ");
            Tools.toString(parameters.entrySet(), msg);
            msg.append(" are not valid");
            throw new IllegalArgumentException(msg.toString());
        }
        throw new UnsupportedOperationException("handle me gracefully method not mapped " + method.getHandle());
    }

    protected final ScopedContext getRequestContext(boolean create) {
        ScopedContext context = (ScopedContext)this.req.getAttribute("juzu.request_scope");
        if (context == null && create) {
            context = new ScopedContext();
            this.req.setAttribute("juzu.request_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getFlashContext(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.flash_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.flash_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getSessionContext(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.session_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.session_scope", (Object)context);
        }
        return context;
    }

    @Override
    public void setResponse(Response response) throws IllegalArgumentException, IOException {
        this.responseHeaders = Collections.emptyMap();
        Iterable<Map.Entry<String, String[]>> headers = response.getProperties().getValues(PropertyType.HEADER);
        if (headers != null) {
            for (Map.Entry<String, String[]> entry : headers) {
                if (this.responseHeaders.isEmpty()) {
                    this.responseHeaders = new HashMap<String, String[]>();
                }
                this.responseHeaders.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public final void begin(Request request) {
        this.request = request;
    }

    @Override
    public void end() {
        this.request = null;
        ScopedContext context = this.getRequestContext(false);
        if (context != null) {
            context.close();
        }
    }

    @Override
    public void close() {
    }

    void send() throws IOException {
    }
}

