/*
 * Decompiled with CFR 0.152.
 */
package inject;

import inject.ScopingContextImpl;
import java.io.File;
import juzu.Scope;
import juzu.impl.common.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopingContext;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectTestCase<B, I>
extends juzu.test.AbstractInjectTestCase {
    protected Injector bootstrap;
    protected InjectionContext<B, I> mgr;
    protected ReadFileSystem<?> fs;
    protected ScopingContextImpl scopingContext;

    public AbstractInjectTestCase(InjectorProvider di) {
        super(di);
    }

    protected final void init() throws Exception {
        this.init(((Object)((Object)this)).getClass().getPackage().getName());
    }

    protected final void init(String pkg) throws Exception {
        File root = new File(AbstractInjectTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        AbstractInjectTestCase.assertTrue((boolean)root.exists());
        AbstractInjectTestCase.assertTrue((boolean)root.isDirectory());
        this.init((ReadFileSystem<?>)new DiskFileSystem(root, pkg), Thread.currentThread().getContextClassLoader());
    }

    protected final void init(ReadFileSystem<?> fs, ClassLoader classLoader) throws Exception {
        Injector bootstrap = this.getManager();
        bootstrap.addFileSystem(fs);
        bootstrap.setClassLoader(classLoader);
        this.bootstrap = bootstrap;
        this.fs = fs;
    }

    protected final void boot(Scope ... scopes) throws Exception {
        this.boot((Filter<Class<?>>)null, scopes);
    }

    protected final void boot(Filter<Class<?>> filter, Scope ... scopes) throws Exception {
        for (Scope scope : scopes) {
            this.bootstrap.addScope(scope);
        }
        this.mgr = filter == null ? this.bootstrap.create() : this.bootstrap.create(filter);
    }

    protected final <T> T getBean(Class<T> beanType) throws Exception {
        Object bean = this.mgr.resolveBean(beanType);
        AbstractInjectTestCase.assertNotNull((String)("Could not resolve bean of type " + beanType), (Object)bean);
        Object beanInstance = this.mgr.create(bean);
        AbstractInjectTestCase.assertNotNull((String)("Could not create bean instance of type " + beanType + " from bean " + bean), (Object)beanInstance);
        Object o = this.mgr.get(bean, beanInstance);
        AbstractInjectTestCase.assertNotNull((String)("Could not obtain bean object from bean instance " + beanInstance + " of type " + beanType), (Object)o);
        return beanType.cast(o);
    }

    protected final Object getBean(String beanName) throws Exception {
        Object bean = this.mgr.resolveBean(beanName);
        AbstractInjectTestCase.assertNotNull((String)("Could not find bean " + beanName), (Object)bean);
        Object beanInstance = this.mgr.create(bean);
        AbstractInjectTestCase.assertNotNull((Object)beanInstance);
        return this.mgr.get(bean, beanInstance);
    }

    protected final void beginScoping() throws Exception {
        if (this.scopingContext != null) {
            throw AbstractInjectTestCase.failure("Already scoping");
        }
        this.scopingContext = new ScopingContextImpl();
        ScopeController.begin((ScopingContext)this.scopingContext);
    }

    protected final void endScoping() throws Exception {
        if (this.scopingContext == null) {
            throw AbstractInjectTestCase.failure("Not scoping");
        }
        ScopeController.end();
        for (Scoped scoped : this.scopingContext.getEntries().values()) {
            scoped.destroy();
        }
        this.scopingContext = null;
    }

    protected final Injector getManager() throws Exception {
        return (Injector)this.getDI().get();
    }
}

