/*
 * Decompiled with CFR 0.152.
 */
package juzu;

import java.util.Arrays;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class PropertyMapTestCase
extends AbstractTestCase {
    public static final PropertyType<String> FOO = new PropertyType<String>(){};

    @Test
    public void testEmpty() {
        PropertyMap pm = new PropertyMap();
        PropertyMapTestCase.assertNull((Object)pm.getValue(FOO));
        PropertyMapTestCase.assertNull((Object)pm.getValues(FOO));
        PropertyMapTestCase.assertFalse((boolean)pm.contains(FOO));
    }

    @Test
    public void testSingleValue() {
        PropertyMap pm = new PropertyMap();
        pm.setValue(FOO, (Object)"1");
        PropertyMapTestCase.assertEquals((String)"1", (String)((String)pm.getValue(FOO)));
        PropertyMapTestCase.assertEquals(Arrays.asList("1"), pm.getValues(FOO));
        PropertyMapTestCase.assertTrue((boolean)pm.contains(FOO));
    }

    @Test
    public void testMultiValue() {
        PropertyMap pm = new PropertyMap();
        pm.setValues(FOO, (Object[])new String[]{"1", "2"});
        PropertyMapTestCase.assertEquals((String)"1", (String)((String)pm.getValue(FOO)));
        PropertyMapTestCase.assertEquals(Arrays.asList("1", "2"), pm.getValues(FOO));
        PropertyMapTestCase.assertTrue((boolean)pm.contains(FOO));
    }

    @Test
    public void testAddValue() {
        PropertyMap pm = new PropertyMap();
        pm.addValue(FOO, (Object)"1");
        PropertyMapTestCase.assertEquals((String)"1", (String)((String)pm.getValue(FOO)));
        PropertyMapTestCase.assertEquals(Arrays.asList("1"), pm.getValues(FOO));
        pm.addValue(FOO, (Object)"2");
        PropertyMapTestCase.assertEquals((String)"1", (String)((String)pm.getValue(FOO)));
        PropertyMapTestCase.assertEquals(Arrays.asList("1", "2"), pm.getValues(FOO));
        PropertyMapTestCase.assertTrue((boolean)pm.contains(FOO));
    }

    @Test
    public void testRemoveEmptyValue() {
        PropertyMap pm = new PropertyMap();
        pm.remove(FOO);
        PropertyMapTestCase.assertNull((Object)pm.getValue(FOO));
        PropertyMapTestCase.assertFalse((boolean)pm.contains(FOO));
    }

    @Test
    public void testRemoveSingleValue() {
        PropertyMap pm = new PropertyMap();
        pm.setValue(FOO, (Object)"1");
        pm.remove(FOO);
        PropertyMapTestCase.assertNull((Object)pm.getValue(FOO));
        PropertyMapTestCase.assertFalse((boolean)pm.contains(FOO));
    }

    @Test
    public void testRemoveMultiValue() {
        PropertyMap pm = new PropertyMap();
        pm.setValues(FOO, (Object[])new String[]{"1", "2"});
        pm.remove(FOO);
        PropertyMapTestCase.assertNull((Object)pm.getValue(FOO));
        PropertyMapTestCase.assertFalse((boolean)pm.contains(FOO));
    }

    @Test
    public void testSingleValueDelegate() {
        PropertyMap pm1 = new PropertyMap();
        PropertyMap pm2 = new PropertyMap(pm1);
        pm1.setValue(FOO, (Object)"1");
        PropertyMapTestCase.assertEquals((String)"1", (String)((String)pm2.getValue(FOO)));
        pm2.setValue(FOO, (Object)"2");
        PropertyMapTestCase.assertEquals((String)"1", (String)((String)pm1.getValue(FOO)));
        PropertyMapTestCase.assertEquals((String)"2", (String)((String)pm2.getValue(FOO)));
    }

    @Test
    public void testMultiValueDelegate() {
        PropertyMap pm1 = new PropertyMap();
        PropertyMap pm2 = new PropertyMap(pm1);
        pm1.setValues(FOO, (Object[])new String[]{"1", "2"});
        PropertyMapTestCase.assertEquals(Arrays.asList("1", "2"), pm2.getValues(FOO));
        pm2.setValue(FOO, (Object)"3");
        PropertyMapTestCase.assertEquals(Arrays.asList("1", "2"), pm1.getValues(FOO));
        PropertyMapTestCase.assertEquals(Arrays.asList("3"), pm2.getValues(FOO));
    }

    @Test
    public void testAddValueDelegate() {
        PropertyMap pm1 = new PropertyMap();
        PropertyMap pm2 = new PropertyMap(pm1);
        pm1.setValues(FOO, (Object[])new String[]{"1"});
        pm2.addValue(FOO, (Object)"2");
        PropertyMapTestCase.assertEquals(Arrays.asList("1"), pm1.getValues(FOO));
        PropertyMapTestCase.assertEquals(Arrays.asList("1", "2"), pm2.getValues(FOO));
    }

    @Test
    public void testRemoveValueDelegate() {
        PropertyMap pm1 = new PropertyMap();
        PropertyMap pm2 = new PropertyMap(pm1);
        pm1.setValues(FOO, (Object[])new String[]{"1"});
        pm2.remove(FOO);
        PropertyMapTestCase.assertEquals(Arrays.asList("1"), pm1.getValues(FOO));
        PropertyMapTestCase.assertNull((Object)pm2.getValues(FOO));
    }
}

