/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import juzu.impl.common.Dev;
import juzu.impl.common.DevClassLoader;
import juzu.impl.common.Lib;
import juzu.impl.common.Tools;
import juzu.test.AbstractTestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;

public class DevClassLoaderTestCase
extends AbstractTestCase {
    private File targetDir;

    public void setUp() {
        String targetPath = System.getProperty("targetDir");
        DevClassLoaderTestCase.assertNotNull((Object)targetPath);
        File targetDir = new File(targetPath);
        DevClassLoaderTestCase.assertTrue((boolean)targetDir.isDirectory());
        this.targetDir = targetDir;
    }

    private ClassLoader getParentClassLoader() {
        ClassLoader systemCL = ClassLoader.getSystemClassLoader();
        ClassLoader extCL = systemCL.getParent();
        try {
            extCL.loadClass(Dev.class.getName());
            DevClassLoaderTestCase.fail();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            extCL.loadClass(Lib.class.getName());
            DevClassLoaderTestCase.fail();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return extCL;
    }

    private File explode(JavaArchive classes, JavaArchive lib) {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class);
        archive.merge((Archive)classes, "WEB-INF/classes");
        archive.addAsDirectory("WEB-INF/lib");
        File explodedDir = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(this.targetDir);
        File libJar = new File(explodedDir, "WEB-INF/lib/lib.jar");
        ((ZipExporter)lib.as(ZipExporter.class)).exportTo(libJar);
        return explodedDir;
    }

    private File archive(JavaArchive classes, JavaArchive lib) {
        try {
            WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class);
            archive.merge((Archive)classes, "WEB-INF/classes");
            archive.addAsLibrary((Archive)lib);
            File tmp = File.createTempFile("archive", ".war", this.targetDir);
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(tmp, true);
            return tmp;
        }
        catch (IOException e) {
            throw DevClassLoaderTestCase.failure(e);
        }
    }

    @Test
    public void testLoad() throws Exception {
        JavaArchive classes = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Dev.class)).addAsResource((Asset)new StringAsset("classes_resource_value"), "classes_resource");
        JavaArchive lib = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Lib.class)).addAsResource((Asset)new StringAsset("lib_resource_value"), "lib_resource");
        File explodedDir = this.explode(classes, lib);
        File libJar = new File(explodedDir, "WEB-INF/lib/lib.jar");
        File classesDir = new File(explodedDir, "WEB-INF/classes");
        URLClassLoader cl = new URLClassLoader(new URL[]{classesDir.toURI().toURL(), libJar.toURI().toURL()}, this.getParentClassLoader());
        Class<?> devClass = cl.loadClass(Dev.class.getName());
        DevClassLoaderTestCase.assertNotSame(devClass, Dev.class);
        Class<?> libClass = cl.loadClass(Lib.class.getName());
        DevClassLoaderTestCase.assertNotSame(libClass, Lib.class);
        InputStream classesResource = cl.getResourceAsStream("classes_resource");
        DevClassLoaderTestCase.assertNotNull((Object)classesResource);
        DevClassLoaderTestCase.assertEquals((String)"classes_resource_value", (String)Tools.read((InputStream)classesResource));
        InputStream libResource = cl.getResourceAsStream("lib_resource");
        DevClassLoaderTestCase.assertNotNull((Object)libResource);
        DevClassLoaderTestCase.assertEquals((String)"lib_resource_value", (String)Tools.read((InputStream)libResource));
        DevClassLoader devCL = new DevClassLoader((ClassLoader)cl);
        try {
            devCL.loadClass(Dev.class.getName());
            DevClassLoaderTestCase.fail();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        DevClassLoaderTestCase.assertSame(libClass, (Object)devCL.loadClass(Lib.class.getName()));
        classesResource = devCL.getResourceAsStream("classes_resource");
        DevClassLoaderTestCase.assertNull((Object)classesResource);
        libResource = devCL.getResourceAsStream("lib_resource");
        DevClassLoaderTestCase.assertNotNull((Object)libResource);
        DevClassLoaderTestCase.assertEquals((String)"lib_resource_value", (String)Tools.read((InputStream)libResource));
    }

    @Test
    public void testShadowedResource() throws Exception {
        JavaArchive classes = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource((Asset)new StringAsset("classes_resource_value"), "resource");
        JavaArchive lib = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Lib.class)).addAsResource((Asset)new StringAsset("lib_resource_value"), "resource");
        File explodedDir = this.explode(classes, lib);
        File libJar = new File(explodedDir, "WEB-INF/lib/lib.jar");
        File classesDir = new File(explodedDir, "WEB-INF/classes");
        URLClassLoader cl = new URLClassLoader(new URL[]{classesDir.toURI().toURL(), libJar.toURI().toURL()}, this.getParentClassLoader());
        DevClassLoader devCL = new DevClassLoader((ClassLoader)cl);
        URL url = devCL.getResource("resource");
        DevClassLoaderTestCase.assertNotNull((Object)url);
        DevClassLoaderTestCase.assertEquals((String)"lib_resource_value", (String)Tools.read((URL)url));
        Enumeration e = devCL.getResources("resource");
        DevClassLoaderTestCase.assertTrue((boolean)e.hasMoreElements());
        url = (URL)e.nextElement();
        DevClassLoaderTestCase.assertNotNull((Object)url);
        DevClassLoaderTestCase.assertEquals((String)"lib_resource_value", (String)Tools.read((URL)url));
        DevClassLoaderTestCase.assertFalse((boolean)e.hasMoreElements());
    }
}

