/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import juzu.impl.common.Introspector;
import org.junit.Test;

public class IntrospectorTestCase {
    @Test
    public void testFoo() {
        Type resolved = Introspector.resolve(ThreadLocal.class, ThreadLocal.class, (int)0);
        Assert.assertTrue((boolean)(resolved instanceof TypeVariable));
        TypeVariable tv = (TypeVariable)resolved;
        Assert.assertEquals(ThreadLocal.class, tv.getGenericDeclaration());
        Assert.assertEquals(Object.class, (Object)Introspector.resolveToClass(ThreadLocal.class, ThreadLocal.class, (int)0));
    }

    @Test
    public void testBar() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A
        extends ThreadLocal<String> {
            A() {
            }
        }
        Type resolved = Introspector.resolve(A.class, ThreadLocal.class, (int)0);
        Assert.assertEquals(String.class, (Object)resolved);
        Assert.assertEquals(String.class, (Object)Introspector.resolveToClass(A.class, ThreadLocal.class, (int)0));
    }

    @Test
    public void testZoo() {
        class A
        extends ThreadLocal {
            A() {
            }
        }
        TypeVariable resolved = (TypeVariable)Introspector.resolve(A.class, ThreadLocal.class, (int)0);
        Assert.assertEquals((String)"T", (String)resolved.getName());
        Assert.assertEquals(Collections.singletonList(Object.class), Arrays.asList(resolved.getBounds()));
        Assert.assertEquals(Object.class, (Object)Introspector.resolveToClass(A.class, ThreadLocal.class, (int)0));
    }

    @Test
    public void testJuu() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A
        extends InheritableThreadLocal<String> {
            A() {
            }
        }
        Type resolved = Introspector.resolve(A.class, ThreadLocal.class, (int)0);
        Assert.assertEquals(String.class, (Object)resolved);
        Assert.assertEquals(String.class, (Object)Introspector.resolveToClass(A.class, ThreadLocal.class, (int)0));
    }

    @Test
    public void testDaa() {
        Type resolved = Introspector.resolve(InheritableThreadLocal.class, ThreadLocal.class, (int)0);
        Assert.assertTrue((boolean)(resolved instanceof TypeVariable));
        TypeVariable tv = (TypeVariable)resolved;
        Assert.assertEquals(InheritableThreadLocal.class, tv.getGenericDeclaration());
        Assert.assertEquals(Object.class, (Object)Introspector.resolveToClass(InheritableThreadLocal.class, ThreadLocal.class, (int)0));
    }

    @Test
    public void testInstanceOf() {
        Assert.assertEquals((boolean)true, (boolean)Introspector.instanceOf(String.class, (String)"java.lang.String"));
        Assert.assertEquals((boolean)true, (boolean)Introspector.instanceOf(ArrayList.class, (String)"java.util.List"));
        Assert.assertEquals((boolean)true, (boolean)Introspector.instanceOf(List.class, (String)"java.util.List"));
        Assert.assertEquals((boolean)true, (boolean)Introspector.instanceOf(ArrayList.class, (String)"java.util.AbstractList"));
        Assert.assertEquals((boolean)true, (boolean)Introspector.instanceOf(ArrayList.class, (String)"java.util.AbstractCollection"));
        Assert.assertEquals((boolean)false, (boolean)Introspector.instanceOf(String.class, (String)"java.lang.Integer"));
    }

    @Test
    public void testInstanceOfList() {
        Assert.assertEquals((boolean)true, (boolean)Introspector.instanceOf(String.class, Arrays.asList("java.lang.String", "java.lang.Integer")));
        Assert.assertEquals((boolean)true, (boolean)Introspector.instanceOf(String.class, Arrays.asList("java.lang.Integer", "java.lang.String")));
        Assert.assertEquals((boolean)false, (boolean)Introspector.instanceOf(String.class, Arrays.asList("java.lang.Boolean", "java.lang.Integer")));
    }
}

