/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.lang.reflect.Method;
import java.util.List;
import juzu.impl.common.MethodHandle;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class MethodHandleTestCase
extends AbstractTestCase {
    @Test
    public void testToString() {
        MethodHandleTestCase.assertEquals((String)"a#b()", (String)new MethodHandle("a", "b").toString());
        MethodHandleTestCase.assertEquals((String)"a#b(c)", (String)new MethodHandle("a", "b", new String[]{"c"}).toString());
        MethodHandleTestCase.assertEquals((String)"a#b(c,d)", (String)new MethodHandle("a", "b", new String[]{"c", "d"}).toString());
    }

    @Test
    public void testInvalid() {
        String[] a;
        for (String s : a = new String[]{"a", "a#", "a#b", "a#b(", "a#b(c", "a#b(,)"}) {
            try {
                MethodHandle.parse((String)s);
                MethodHandleTestCase.fail();
            }
            catch (IllegalArgumentException ignore) {
                // empty catch block
            }
        }
    }

    @Test
    public void testParse() {
        MethodHandleTestCase.assertEquals((Object)new MethodHandle("a", "b"), (Object)MethodHandle.parse((String)"a#b()"));
        MethodHandleTestCase.assertEquals((Object)new MethodHandle("a", "b", new String[]{"c"}), (Object)MethodHandle.parse((String)"a#b(c)"));
        MethodHandleTestCase.assertEquals((Object)new MethodHandle("a", "b", new String[]{"c", "d"}), (Object)MethodHandle.parse((String)"a#b(c,d)"));
    }

    @Test
    public void testJavaLangReflectMethod() {
        MethodHandleTestCase.assertParameterTypes(MethodHandleTestCase.getMethod(new Object(){

            public void m(String p) {
            }
        }), "java.lang.String");
        MethodHandleTestCase.assertParameterTypes(MethodHandleTestCase.getMethod(new Object(){

            public void m(String[] p) {
            }
        }), "java.lang.String[]");
        MethodHandleTestCase.assertParameterTypes(MethodHandleTestCase.getMethod(new Object(){

            public void m(String[][] p) {
            }
        }), "java.lang.String[][]");
        MethodHandleTestCase.assertParameterTypes(MethodHandleTestCase.getMethod(new Object(){

            public void m(List<String> p) {
            }
        }), "java.util.List<java.lang.String>");
        MethodHandleTestCase.assertParameterTypes(MethodHandleTestCase.getMethod(new Object(){

            public void m(List<String>[] p) {
            }
        }), "java.util.List<java.lang.String>[]");
    }

    private static void assertParameterTypes(Method m, String ... parameterTypes) {
        MethodHandle handle = new MethodHandle(m);
        MethodHandleTestCase.assertEquals((int)parameterTypes.length, (int)handle.getParameterSize());
        for (int i = 0; i < parameterTypes.length; ++i) {
            MethodHandleTestCase.assertEquals((String)parameterTypes[i], (String)handle.getParameterAt(i));
        }
    }

    private static Method getMethod(Object o) {
        return o.getClass().getDeclaredMethods()[0];
    }
}

