/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import juzu.impl.common.Tools;
import juzu.impl.common.Trie;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class ToolsTestCase
extends AbstractTestCase {
    @Test
    public void testEmptyNoRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"", (boolean)false);
        ToolsTestCase.assertTrue((boolean)p.matcher("").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo.bar").matches());
    }

    @Test
    public void testEmptyRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"", (boolean)true);
        ToolsTestCase.assertTrue((boolean)p.matcher("").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo.bar").matches());
    }

    @Test
    public void testNoRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"foo", (boolean)false);
        ToolsTestCase.assertTrue((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("bar").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo.bar").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo.bar.juu").matches());
    }

    @Test
    public void testRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"foo", (boolean)true);
        ToolsTestCase.assertTrue((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo.bar").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo.bar.juu").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("bar").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foobar").matches());
    }

    @Test
    public void testUnquote() {
        ToolsTestCase.assertEquals((String)"", (String)Tools.unquote((String)""));
        ToolsTestCase.assertEquals((String)"'", (String)Tools.unquote((String)"'"));
        ToolsTestCase.assertEquals((String)"\"", (String)Tools.unquote((String)"\""));
        ToolsTestCase.assertEquals((String)"'\"", (String)Tools.unquote((String)"'\""));
        ToolsTestCase.assertEquals((String)"\"'", (String)Tools.unquote((String)"\"'"));
        ToolsTestCase.assertEquals((String)"", (String)Tools.unquote((String)"''"));
        ToolsTestCase.assertEquals((String)"", (String)Tools.unquote((String)"\"\""));
        ToolsTestCase.assertEquals((String)"a", (String)Tools.unquote((String)"'a'"));
        ToolsTestCase.assertEquals((String)"a", (String)Tools.unquote((String)"\"a\""));
        ToolsTestCase.assertEquals((String)"'a\"", (String)Tools.unquote((String)"'a\""));
        ToolsTestCase.assertEquals((String)"\"a'", (String)Tools.unquote((String)"\"a'"));
    }

    @Test
    public void testCount() {
        ToolsTestCase.assertEquals((int)0, (int)Tools.count((String)"a", (String)"b"));
        ToolsTestCase.assertEquals((int)1, (int)Tools.count((String)"a", (String)"a"));
        ToolsTestCase.assertEquals((int)2, (int)Tools.count((String)"aa", (String)"a"));
        ToolsTestCase.assertEquals((int)1, (int)Tools.count((String)"", (String)""));
        ToolsTestCase.assertEquals((int)2, (int)Tools.count((String)"a", (String)""));
        ToolsTestCase.assertEquals((int)3, (int)Tools.count((String)"aa", (String)""));
        ToolsTestCase.assertEquals((int)1, (int)Tools.count((String)"aaa", (String)"aa"));
    }

    @Test
    public void testSplit() {
        ToolsTestCase.assertEquals(Collections.emptyList(), Arrays.asList(Tools.split((CharSequence)"", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("a"), Arrays.asList(Tools.split((CharSequence)"a", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("a", ""), Arrays.asList(Tools.split((CharSequence)"a.", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("", "a"), Arrays.asList(Tools.split((CharSequence)".a", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("", ""), Arrays.asList(Tools.split((CharSequence)".", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("a", "b"), Arrays.asList(Tools.split((CharSequence)"a.b", (char)'.')));
        String[] ret = Tools.split((CharSequence)"a.b", (char)'.', (int)1);
        ToolsTestCase.assertEquals((int)3, (int)ret.length);
        ToolsTestCase.assertEquals((String)"a", (String)ret[0]);
        ToolsTestCase.assertEquals((String)"b", (String)ret[1]);
        ToolsTestCase.assertEquals(null, (String)ret[2]);
        ret = Tools.split((CharSequence)"", (char)'.', (int)1);
        ToolsTestCase.assertEquals((int)1, (int)ret.length);
        ToolsTestCase.assertEquals(null, (String)ret[0]);
    }

    @Test
    public void testIteratorAppend() {
        Iterator i = Tools.append(Collections.emptyList().iterator(), (Object[])new Object[]{"foo"});
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"foo", i.next());
        ToolsTestCase.assertFalse((boolean)i.hasNext());
        ToolsTestCase.assertNoSuchElement(i);
        i = Tools.append(Collections.singletonList("foo").iterator(), (Object[])new String[0]);
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"foo", i.next());
        ToolsTestCase.assertFalse((boolean)i.hasNext());
        ToolsTestCase.assertNoSuchElement(i);
        i = Tools.append(Collections.singletonList("foo").iterator(), (Object[])new String[]{"bar"});
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"foo", i.next());
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"bar", i.next());
        ToolsTestCase.assertFalse((boolean)i.hasNext());
        ToolsTestCase.assertNoSuchElement(i);
    }

    @Test
    public void testTrieEmpty() {
        Trie trie = new Trie();
        ToolsTestCase.assertNull((Object)trie.getParent());
        ToolsTestCase.assertNull((Object)trie.getKey());
        ToolsTestCase.assertEquals(Collections.emptyList(), Tools.list((Iterable)trie.getPath()));
        ToolsTestCase.assertNull((Object)trie.value());
        ToolsTestCase.assertNull((Object)trie.value((Object)"foo"));
        ToolsTestCase.assertEquals((String)"foo", (String)((String)trie.value()));
        ToolsTestCase.assertEquals((String)"foo", (String)((String)trie.value((Object)"bar")));
        ToolsTestCase.assertEquals((String)"bar", (String)((String)trie.value()));
        ToolsTestCase.assertEquals((String)"bar", (String)((String)trie.value((Object)"juu")));
    }

    @Test
    public void testTrieAddKey() {
        Trie root = new Trie();
        Trie foo = (Trie)root.add((Object)"foo");
        ToolsTestCase.assertSame((Object)foo, (Object)root.get((Object)"foo"));
        ToolsTestCase.assertSame((Object)foo, (Object)root.add((Object)"foo"));
        ToolsTestCase.assertSame((Object)root, (Object)foo.getParent());
    }

    @Test
    public void testTrieAddKeys() {
        Trie root = new Trie();
        Trie bar = (Trie)root.add((Object[])new String[]{"foo", "bar"});
        Trie foo = (Trie)bar.getParent();
        ToolsTestCase.assertSame((Object)foo, (Object)root.get((Object)"foo"));
        ToolsTestCase.assertSame((Object)foo, (Object)root.add((Object)"foo"));
        ToolsTestCase.assertSame((Object)root, (Object)foo.getParent());
        ToolsTestCase.assertSame((Object)bar, (Object)foo.get((Object)"bar"));
        ToolsTestCase.assertSame((Object)bar, (Object)foo.add((Object)"bar"));
    }
}

