/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.test.AbstractTestCase;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;

public class ReadFileSystemTestCase
extends AbstractTestCase {
    @Test
    public void testWar1() throws Exception {
        File war = File.createTempFile("foo", ".war");
        war.deleteOnExit();
        ((ZipExporter)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibrary(((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"foo.jar")).addClass(ReadFileSystemTestCase.class))).as(ZipExporter.class)).exportTo(war, true);
        URL url = new URL("jar:" + war.toURI().toURL() + "!/WEB-INF/lib/foo.jar");
        this.assertJar(url);
        this.assertFS(url);
    }

    @Test
    public void testWar2() throws Exception {
        File tmp = File.createTempFile("juzu", "juzu");
        ReadFileSystemTestCase.assertTrue((boolean)tmp.delete());
        tmp.deleteOnExit();
        File war = new File(tmp, "foo.war");
        File lib = new File(war, "WEB-INF/lib");
        ReadFileSystemTestCase.assertTrue((boolean)lib.mkdirs());
        File jar = new File(lib, "foo.jar");
        ((ZipExporter)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ReadFileSystemTestCase.class)).as(ZipExporter.class)).exportTo(jar);
        URL url = jar.toURI().toURL();
        this.assertJar(url);
        this.assertFS(url);
    }

    @Test
    public void testWar3() throws Exception {
        File tmp = File.createTempFile("juzu", "juzu");
        ReadFileSystemTestCase.assertTrue((boolean)tmp.delete());
        ReadFileSystemTestCase.assertTrue((boolean)tmp.mkdirs());
        tmp.deleteOnExit();
        ((ExplodedExporter)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"foo.war")).addAsLibrary(((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"foo.jar")).addClass(ReadFileSystemTestCase.class))).as(ExplodedExporter.class)).exportExploded(tmp);
        File jar = new File(tmp, "foo.war/WEB-INF/lib/foo.jar");
        ReadFileSystemTestCase.assertTrue((boolean)jar.exists());
        ReadFileSystemTestCase.assertTrue((boolean)jar.isDirectory());
        URL url = jar.toURI().toURL();
        this.assertFS(url);
    }

    private void assertJar(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream in = conn.getInputStream();
        JavaArchive archive = (JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class)).importFrom(in)).as(JavaArchive.class);
        Node node = archive.get("/" + ReadFileSystemTestCase.class.getName().replace('.', '/') + ".class");
        ReadFileSystemTestCase.assertNotNull((Object)node);
    }

    private void assertFS(URL url) throws IOException {
        ReadFileSystem fs = ReadFileSystem.create((URL)url);
        Object path = fs.getPath(new String[]{"juzu", "impl", "fs", "spi", "ReadFileSystemTestCase.class"});
        ReadFileSystemTestCase.assertNotNull((Object)path);
    }
}

