/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.ram;

import java.io.IOException;
import juzu.impl.common.Content;
import juzu.impl.fs.spi.AbstractReadWriteFileSystemTestCase;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMFileSystemTestCase
extends AbstractReadWriteFileSystemTestCase<String[]> {
    @Override
    protected ReadWriteFileSystem<String[]> create() throws IOException {
        return new RAMFileSystem();
    }

    @Test
    public void testLastModified() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        String[] fooTxt = fs.makePath(fs.getRoot(), "foo.txt");
        fs.setContent(fooTxt, new Content((CharSequence)"abc"));
        long now = RAMFileSystemTestCase.waitForOneMillis();
        RAMFileSystemTestCase.assertTrue((fs.getLastModified(fooTxt) < now ? 1 : 0) != 0);
        RAMFileSystemTestCase.waitForOneMillis();
        fs.setContent(fooTxt, new Content((CharSequence)"def"));
        RAMFileSystemTestCase.assertTrue((now < fs.getLastModified(fooTxt) ? 1 : 0) != 0);
    }
}

