/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.util.LinkedList;
import junit.framework.Assert;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelObject;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public abstract class MetaModelTestCase
extends AbstractTestCase {
    private static final Key<MetaModelObject> A = Key.of((Object)"a", MetaModelObject.class);
    private static final Key<MetaModelObject> B = Key.of((Object)"b", MetaModelObject.class);
    private static final Key<MetaModelObject> C = Key.of((Object)"c", MetaModelObject.class);
    private static final Key<MetaModelObject> D = Key.of((Object)"d", MetaModelObject.class);
    private Context context;

    public void setUp() throws Exception {
        this.context = new Context();
    }

    @Test
    public void testCannotRemoveRoot() {
        Simple a = this.context.create("a");
        Simple b = this.context.create("b");
        a.addChild(B, b);
        a.remove();
        MetaModelTestCase.assertSame((Object)((Object)b), (Object)a.getChild(B));
        this.context.assertEmpty();
    }

    @Test
    public void testTransitiveRemove() {
        Simple a = this.context.create("a");
        Simple b = this.context.create("b");
        Simple c = this.context.create("c");
        a.addChild(B, b).addChild(C, (MetaModelObject)c);
        b.remove();
        this.context.assertPreDetach("c");
        this.context.assertRemove("c");
        this.context.assertPreDetach("b");
        this.context.assertRemove("b");
        this.context.assertEmpty();
    }

    @Test
    public void testTransitiveRemoveChild() {
        Simple a = this.context.create("a");
        Simple b = this.context.create("b");
        Simple c = this.context.create("c");
        a.addChild(B, b).addChild(C, (MetaModelObject)c);
        a.removeChild(B);
        this.context.assertPreDetach("c");
        this.context.assertRemove("c");
        this.context.assertPreDetach("b");
        this.context.assertRemove("b");
        this.context.assertEmpty();
    }

    @Test
    public void testRemoveOrphan() {
        Simple a = this.context.create("a");
        Simple b = this.context.create("b");
        Simple c = this.context.create("c");
        a.addChild(C, c);
        b.addChild(C, c);
        a.removeChild(C);
        this.context.assertPreDetach("c");
        this.context.assertEmpty();
        b.removeChild(C);
        this.context.assertPreDetach("c");
        this.context.assertRemove("c");
        this.context.assertEmpty();
    }

    @Test
    public void testBug() {
        Simple a = this.context.create("a");
        Simple b = this.context.create("b");
        Simple c = this.context.create("c");
        Simple d = this.context.create("d");
        a.addChild(C, c);
        b.addChild(C, c);
        c.addChild(D, d);
        MetaModelTestCase.assertSame((Object)((Object)c), (Object)a.removeChild(C));
        MetaModelTestCase.assertNull((Object)a.getChild(C));
        MetaModelTestCase.assertSame((Object)((Object)c), (Object)b.getChild(C));
        MetaModelTestCase.assertSame((Object)((Object)d), (Object)c.getChild(D));
    }

    @Test
    public void testEventWhenRemoved() {
        Simple a = this.context.create("a");
        Simple b = this.context.create("b");
        a.addChild(B, b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Context
    extends LinkedList<Event> {
        Context() {
        }

        Simple create(String name) {
            return new Simple(this, name);
        }

        void assertRemove(String name) {
            Assert.assertTrue((String)"Expecting to have at least one event", (this.size() > 0 ? 1 : 0) != 0);
            Event event = (Event)this.removeFirst();
            Assert.assertEquals((int)1, (int)event.kind);
            Assert.assertEquals((String)name, (String)((Event)event).source.name);
        }

        void assertPreDetach(String name) {
            Assert.assertTrue((String)"Expecting to have at least one event", (this.size() > 0 ? 1 : 0) != 0);
            Event event = (Event)this.removeFirst();
            Assert.assertEquals((int)2, (int)event.kind);
            Assert.assertEquals((String)name, (String)((Event)event).source.name);
        }

        void assertEmpty() {
            Assert.assertTrue((boolean)this.isEmpty());
        }
    }

    static class Event {
        static final int ADDED = 0;
        static final int REMOVED = 1;
        static final int PRE_DETACH = 2;
        private final Simple source;
        private final int kind;

        Event(Simple source, int kind) {
            this.source = source;
            this.kind = kind;
        }
    }

    static class Simple
    extends MetaModelObject {
        final Context context;
        final String name;

        Simple(Context context, String name) {
            this.context = context;
            this.name = name;
        }

        protected void preDetach(MetaModelObject parent) {
            this.context.addLast(new Event(this, 2));
        }

        protected void preRemove() {
            this.context.addLast(new Event(this, 1));
        }

        public String toString() {
            return "Simple[" + this.name + "]";
        }
    }
}

