/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.router.metamodel.RouteMetaModel;
import juzu.impl.plugin.router.metamodel.RouterMetaModel;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class RouterTestCase
extends AbstractTestCase {
    @Test
    public void testDuplicateMethodRoute() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("metamodel.router.duplicate.methodroute").formalErrorReporting(true);
        List<CompilationError> errors = helper.failCompile();
        RouterTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        RouterTestCase.assertSame((Object)RouterMetaModel.ROUTER_DUPLICATE_ROUTE, (Object)error.getCode());
        RouterTestCase.assertEquals(Arrays.asList("/foo"), error.getArguments());
        File f = (File)helper.getSourcePath().getPath(new String[]{"metamodel", "router", "duplicate", "methodroute", "A.java"});
        RouterTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testParamPattern() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("metamodel.router.param.pattern").formalErrorReporting(true);
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        ModuleMetaModel mm = (ModuleMetaModel)((MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser)).metaModel;
        ApplicationMetaModel application = (ApplicationMetaModel)mm.getChild(Key.of((Object)ElementHandle.Package.create((Name)Name.parse((CharSequence)"metamodel.router.param.pattern")), ApplicationMetaModel.class));
        RouterMetaModel router = (RouterMetaModel)application.getChild(Key.of(RouterMetaModel.class));
        RouteMetaModel root = router.getRoot();
        RouteMetaModel route = (RouteMetaModel)root.getChildren().get(0);
        RouterTestCase.assertEquals((String)"/{foo}", (String)route.getPath());
        RouterTestCase.assertEquals(Collections.singletonMap("foo", ".*"), (Object)route.getParameters());
    }
}

