/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import juzu.impl.compiler.CompilationError;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.binding.BindingMetaModelPlugin;
import juzu.inject.ProviderFactory;
import juzu.test.AbstractInjectTestCase;
import juzu.test.CompilerAssert;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class BindingProviderFactoryTestCase
extends AbstractInjectTestCase {
    public BindingProviderFactoryTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testNoPublicCtor() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.provider.factory.nopublicctor");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.PROVIDER_FACTORY_NO_PUBLIC_CTOR, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "provider", "factory", "nopublicctor", "package-info.java"});
        BindingProviderFactoryTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testNoZeroCtor() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.provider.factory.nozeroargctor");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.PROVIDER_FACTORY_NO_ZERO_ARG_CTOR, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "provider", "factory", "nozeroargctor", "package-info.java"});
        BindingProviderFactoryTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testAbstractClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.provider.factory.abstractclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.IMPLEMENTATION_NOT_ABSTRACT, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "provider", "factory", "abstractclass", "package-info.java"});
        BindingProviderFactoryTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testNotPublicClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.provider.factory.notpublicclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.PROVIDER_FACTORY_NOT_PUBLIC, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "provider", "factory", "notpublicclass", "package-info.java"});
        BindingProviderFactoryTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testCreate() throws Exception {
        MockApplication<File> app = this.application("plugin.binding.provider.factory.create");
        File root = (File)app.getClasses().getRoot();
        File services = new File(root, "META-INF/services");
        BindingProviderFactoryTestCase.assertTrue((boolean)services.mkdirs());
        File providers = new File(services, ProviderFactory.class.getName());
        FileWriter writer = new FileWriter(providers);
        writer.append("plugin.binding.provider.factory.create.ProviderFactoryImpl");
        writer.close();
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        BindingProviderFactoryTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }

    @Test
    public void testGetProviderThrowable() throws Exception {
        MockApplication<File> app = this.application("plugin.binding.provider.factory.throwable");
        File root = (File)app.getClasses().getRoot();
        File services = new File(root, "META-INF/services");
        BindingProviderFactoryTestCase.assertTrue((boolean)services.mkdirs());
        File providers = new File(services, ProviderFactory.class.getName());
        FileWriter writer = new FileWriter(providers);
        writer.append("plugin.binding.provider.factory.throwable.ServiceProviderFactory");
        writer.close();
        try {
            app.init();
            BindingProviderFactoryTestCase.fail();
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }
}

