/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.io.File;
import java.util.List;
import juzu.impl.compiler.CompilationError;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.binding.BindingMetaModelPlugin;
import juzu.test.AbstractInjectTestCase;
import juzu.test.CompilerAssert;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class BindingProviderTestCase
extends AbstractInjectTestCase {
    public BindingProviderTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testProvider() throws Exception {
        MockApplication<File> app = this.application("plugin.binding.provider.create").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        BindingProviderTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }

    @Test
    public void testNotAssignable() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.provider.notassignable");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderTestCase.assertEquals((Object)BindingMetaModelPlugin.PROVIDER_NOT_ASSIGNABLE, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "provider", "notassignable", "package-info.java"});
        BindingProviderTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testAbstractClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.provider.abstractclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderTestCase.assertEquals((Object)BindingMetaModelPlugin.IMPLEMENTATION_NOT_ABSTRACT, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "provider", "abstractclass", "package-info.java"});
        BindingProviderTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testQualifiedProvider() throws Exception {
        MockApplication<File> app = this.application("plugin.binding.provider.qualified").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        BindingProviderTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }
}

