/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.File;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockActionBridge;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class RenderTestCase
extends AbstractInjectTestCase {
    private static final Pattern P = Pattern.compile("([0-9]+)\\[(.*)\\]");

    public RenderTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testIndex() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.render.index").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        RenderTestCase.assertEquals((String)"index", (String)render.assertStringResult());
    }

    @Test
    public void testParameterizedIndex() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.render.parameterizedindex").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        Matcher m = P.matcher(render.assertStringResult());
        RenderTestCase.assertTrue((String)("Was expecting " + render.assertStringResult() + " to match"), (boolean)m.matches());
        RenderTestCase.assertEquals((String)"0", (String)m.group(1));
        render = (MockRenderBridge)client.invoke(m.group(2));
        m.reset(render.assertStringResult());
        RenderTestCase.assertTrue((String)("Was expecting " + render.assertStringResult() + " to match"), (boolean)m.matches());
        RenderTestCase.assertEquals((String)"1", (String)m.group(1));
        render = (MockRenderBridge)client.invoke(m.group(2));
        m.reset(render.assertStringResult());
        RenderTestCase.assertTrue((String)("Was expecting " + render.assertStringResult() + " to match"), (boolean)m.matches());
        RenderTestCase.assertEquals((String)"0", (String)m.group(1));
    }

    @Test
    public void testOverridenIndex() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.render.overridenindex").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        Matcher m = P.matcher(render.assertStringResult());
        RenderTestCase.assertTrue((String)("Was expecting " + render.assertStringResult() + " to match"), (boolean)m.matches());
        RenderTestCase.assertEquals((String)"0", (String)m.group(1));
        render = (MockRenderBridge)client.invoke(m.group(2));
        m.reset(render.assertStringResult());
        RenderTestCase.assertTrue((String)("Was expecting " + render.assertStringResult() + " to match"), (boolean)m.matches());
        RenderTestCase.assertEquals((String)"1", (String)m.group(1));
        render = (MockRenderBridge)client.invoke(m.group(2));
        m.reset(render.assertStringResult());
        RenderTestCase.assertTrue((String)("Was expecting " + render.assertStringResult() + " to match"), (boolean)m.matches());
        RenderTestCase.assertEquals((String)"2", (String)m.group(1));
    }

    @Test
    public void testResponse() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.render.response").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        RenderTestCase.assertEquals((String)"foo", (String)render.assertStringResult());
    }

    @Test
    public void testUpdate() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.render.update").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        String url = render.assertStringResult();
        MockActionBridge action = (MockActionBridge)client.invoke(url);
        action.assertRender("A.done", Collections.<String, String>emptyMap());
    }
}

