/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.List;
import juzu.impl.router.CaptureGroupTransformation;
import juzu.impl.router.ValueResolverFactory;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.REVisitor;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class FooVisitorTestCase
extends AbstractTestCase {
    private static void assertSatisfied(String expression, String ... expected) throws Exception {
        RENode root = new REParser((CharSequence)expression).parse();
        root.accept((REVisitor)new CaptureGroupTransformation());
        List alternatives = new ValueResolverFactory().foo(root);
        FooVisitorTestCase.assertEquals((int)expected.length, (int)alternatives.size());
        for (int i = 0; i < expected.length; ++i) {
            FooVisitorTestCase.assertEquals((String)expected[i], (String)((ValueResolverFactory.Alternative)alternatives.get(i)).getResolvingExpression().toString());
        }
    }

    @Test
    public void testDisjunctions() throws Exception {
        FooVisitorTestCase.assertSatisfied("a|.", "(a)", "(.)");
        FooVisitorTestCase.assertSatisfied("a(.)b|.", "a(.)b", "(.)");
    }

    @Test
    public void testDisjunction() throws Exception {
        FooVisitorTestCase.assertSatisfied("(?:a|b)(.)b", "a(.)b");
    }

    @Test
    public void testAlternative() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)b", "a(.)b");
    }

    @Test
    public void testCharacterClassRange() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)[b-c]", "a(.)b");
    }

    @Test
    public void testCharacterClassOr() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)[bc]", "a(.)b");
    }

    @Test
    public void testCharacterClassAnd() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)[b&&b]", "a(.)b");
    }

    @Test
    public void testQuantifier() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)b{2,3}", "a(.)bb");
    }

    @Test
    public void testCharacterClassNegateChar() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)[^a]", "a(.) ");
    }

    @Test
    public void testCharacterClassNegateOr() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)[^ !]", "a(.)\"");
    }

    @Test
    public void testCharacterClassNegateAnd() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)[^a&&b]", "a(.) ");
    }

    @Test
    public void testAny() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.).", "a(.)a");
    }

    @Test
    public void testComplex() throws Exception {
        FooVisitorTestCase.assertSatisfied("a(.)[a-z&&f-t&&p-q]", "a(.)p");
    }
}

