/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.io.IOException;
import juzu.impl.router.CaptureGroupTransformation;
import juzu.impl.router.NonCaptureGroupTransformation;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.RERenderer;
import juzu.impl.router.regex.REVisitor;
import juzu.impl.router.regex.SyntaxException;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class GroupTransformationTestCase
extends AbstractTestCase {
    @Test
    public void testCapturing() throws SyntaxException, IOException {
        this.assertCapturing("a", "(a)");
        this.assertCapturing("(a)", "(a)");
        this.assertCapturing("a(b)c", "a(b)c");
        this.assertCapturing("(a)?", "((?:a)?)");
        this.assertCapturing("a|b", "(a)|(b)");
        this.assertCapturing("(a)|b", "(a)|(b)");
        this.assertCapturing("(a|b)", "(a|b)");
        this.assertCapturing("(a)(b)", "((?:a)(?:b))");
        this.assertCapturing("(a)|", "(a)|()");
        this.assertCapturing("|(a)", "()|(a)");
        this.assertCapturing("|", "()|()");
    }

    @Test
    public void testNonCapturing() throws SyntaxException, IOException {
        this.assertNonCapturing("a", "(a)");
        this.assertNonCapturing("(a)", "((?:a))");
        this.assertNonCapturing("a(b)c", "(a(?:b)c)");
        this.assertNonCapturing("(a)|b", "((?:a)|b)");
    }

    private void assertNonCapturing(String test, String expected) throws SyntaxException, IOException {
        this.assertTransform(test, expected, false);
    }

    private void assertCapturing(String test, String expected) throws SyntaxException, IOException {
        this.assertTransform(test, expected, true);
    }

    private void assertTransform(String test, String expected, boolean capturing) throws SyntaxException, IOException {
        RENode node = new REParser((CharSequence)test).parse();
        CaptureGroupTransformation transformer = capturing ? new CaptureGroupTransformation() : new NonCaptureGroupTransformation();
        node.accept((REVisitor)transformer);
        StringBuilder sb = new StringBuilder();
        RERenderer renderer = new RERenderer((Appendable)sb);
        node.accept((REVisitor)renderer);
        GroupTransformationTestCase.assertEquals((String)expected, (String)sb.toString());
    }
}

