/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import juzu.impl.router.AbstractControllerTestCase;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteKind;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.RouterAssert;
import org.junit.Test;

public class MatchTestCase
extends AbstractControllerTestCase {
    @Test
    public void testRoot1() throws Exception {
        RouterAssert router = new RouterAssert();
        Route foo = router.append("/");
        MatchTestCase.assertNotSame((Object)foo, (Object)((Object)router));
        router.assertRoute(Collections.<String, String>emptyMap(), "");
        router.assertRoute(Collections.<String, String>emptyMap(), "/");
        MatchTestCase.assertNull((Object)router.route("/a"));
        MatchTestCase.assertNull((Object)router.route("a"));
    }

    @Test
    public void testRoot2() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("");
        router.assertRoute(Collections.<String, String>emptyMap(), "");
        router.assertRoute(Collections.<String, String>emptyMap(), "/");
        MatchTestCase.assertNull((Object)router.route("/a"));
        MatchTestCase.assertNull((Object)router.route("a"));
    }

    @Test
    public void testRoot3() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/", RouteKind.MATCH_ANY);
        router.assertRoute(Collections.<String, String>emptyMap(), "");
        router.assertRoute(Collections.<String, String>emptyMap(), "/");
        MatchTestCase.assertNull((Object)router.route("/a"));
        MatchTestCase.assertNull((Object)router.route("a"));
    }

    @Test
    public void testEmpty1() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/").append("/foo");
        router.assertRoute(Collections.<String, String>emptyMap(), "");
        router.assertRoute(Collections.<String, String>emptyMap(), "/");
        router.assertRoute(Collections.<String, String>emptyMap(), "/foo");
        router.assertRoute(Collections.<String, String>emptyMap(), "foo");
    }

    @Test
    public void testEmpty2() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/foo").append("/").append("/bar");
        router.assertRoute(Collections.<String, String>emptyMap(), "/foo");
        router.assertRoute(Collections.<String, String>emptyMap(), "foo");
        router.assertRoute(Collections.<String, String>emptyMap(), "foo/bar");
        router.assertRoute(Collections.<String, String>emptyMap(), "/foo/bar");
    }

    @Test
    public void testA1() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/a");
        router.assertRoute(Collections.<String, String>emptyMap(), "/a");
        router.assertRoute(Collections.<String, String>emptyMap(), "a");
        MatchTestCase.assertNull((Object)router.route("a/"));
        MatchTestCase.assertNull((Object)router.route("/a/"));
        MatchTestCase.assertNull((Object)router.route(""));
        MatchTestCase.assertNull((Object)router.route("/"));
        MatchTestCase.assertNull((Object)router.route("/b"));
        MatchTestCase.assertNull((Object)router.route("b"));
        MatchTestCase.assertNull((Object)router.route("/a/b"));
    }

    @Test
    public void testA2() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/a/");
        MatchTestCase.assertNull((Object)router.route("/a"));
        MatchTestCase.assertNull((Object)router.route("a"));
        router.assertRoute(Collections.<String, String>emptyMap(), "a/");
        router.assertRoute(Collections.<String, String>emptyMap(), "/a/");
        MatchTestCase.assertNull((Object)router.route(""));
        MatchTestCase.assertNull((Object)router.route("/"));
        MatchTestCase.assertNull((Object)router.route("/b"));
        MatchTestCase.assertNull((Object)router.route("b"));
        MatchTestCase.assertNull((Object)router.route("/a/b"));
    }

    @Test
    public void testA3() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/a", RouteKind.MATCH_ANY);
        router.assertRoute(Collections.<String, String>emptyMap(), "/a");
        router.assertRoute(Collections.<String, String>emptyMap(), "a");
        router.assertRoute(Collections.<String, String>emptyMap(), "a/");
        router.assertRoute(Collections.<String, String>emptyMap(), "/a/");
        MatchTestCase.assertNull((Object)router.route(""));
        MatchTestCase.assertNull((Object)router.route("/"));
        MatchTestCase.assertNull((Object)router.route("/b"));
        MatchTestCase.assertNull((Object)router.route("b"));
        MatchTestCase.assertNull((Object)router.route("/a/b"));
    }

    @Test
    public void testAB1() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/a/b");
        router.assertRoute(Collections.<String, String>emptyMap(), "a/b");
        router.assertRoute(Collections.<String, String>emptyMap(), "/a/b");
        MatchTestCase.assertNull((Object)router.route("/a/b/"));
        MatchTestCase.assertNull((Object)router.route("a/b/"));
        MatchTestCase.assertNull((Object)router.route(""));
        MatchTestCase.assertNull((Object)router.route("/"));
        MatchTestCase.assertNull((Object)router.route("/b"));
        MatchTestCase.assertNull((Object)router.route("b"));
        MatchTestCase.assertNull((Object)router.route("/a/b/c"));
    }

    @Test
    public void testAB2() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/a/b/");
        MatchTestCase.assertNull((Object)router.route("a/b"));
        MatchTestCase.assertNull((Object)router.route("/a/b"));
        router.assertRoute(Collections.<String, String>emptyMap(), "/a/b/");
        router.assertRoute(Collections.<String, String>emptyMap(), "a/b/");
        MatchTestCase.assertNull((Object)router.route(""));
        MatchTestCase.assertNull((Object)router.route("/"));
        MatchTestCase.assertNull((Object)router.route("/b"));
        MatchTestCase.assertNull((Object)router.route("b"));
        MatchTestCase.assertNull((Object)router.route("/a/b/c"));
    }

    @Test
    public void testAB3() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/a/b", RouteKind.MATCH_ANY);
        router.assertRoute(Collections.<String, String>emptyMap(), "a/b");
        router.assertRoute(Collections.<String, String>emptyMap(), "/a/b");
        router.assertRoute(Collections.<String, String>emptyMap(), "/a/b/");
        router.assertRoute(Collections.<String, String>emptyMap(), "a/b/");
        MatchTestCase.assertNull((Object)router.route(""));
        MatchTestCase.assertNull((Object)router.route("/"));
        MatchTestCase.assertNull((Object)router.route("/b"));
        MatchTestCase.assertNull((Object)router.route("b"));
        MatchTestCase.assertNull((Object)router.route("/a/b/c"));
    }

    @Test
    public void testParameter() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/{p}");
        router.assertRoute(Collections.singletonMap("p", "a"), "/a");
    }

    @Test
    public void testParameterPropagationToDescendants() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/a").append("/b");
        router.assertRoute(a, "/a/b");
    }

    @Test
    public void testSimplePattern() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)"a")));
        router.assertRoute(Collections.singletonMap("p", "a"), "/a");
        router.assertRoute(Collections.singletonMap("p", "a"), "a");
        MatchTestCase.assertNull((Object)router.route("/ab"));
        MatchTestCase.assertNull((Object)router.route("ab"));
    }

    @Test
    public void testPrecedence() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/a");
        router.append("/{p}/b", Collections.singletonMap("p", PathParam.matching((String)"a")));
        router.assertRoute(Collections.<String, String>emptyMap(), "a");
        router.assertRoute(Collections.<String, String>emptyMap(), "/a");
        MatchTestCase.assertNull((Object)router.route("/a/"));
        router.assertRoute(Collections.singletonMap("p", "a"), "/a/b");
    }

    @Test
    public void testTwoRules1() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/a");
        Route b = router.append("/a/b");
        router.assertRoute(a, "/a");
        router.assertRoute(b, "/a/b");
    }

    @Test
    public void testTwoRules2() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{a}");
        Route b = router.append("/{a}/b");
        router.assertRoute(a, Collections.singletonMap("a", "a"), "/a");
        router.assertRoute(b, Collections.singletonMap("a", "a"), "/a/b");
    }

    @Test
    public void testLang() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/{a}b", Collections.singletonMap("a", PathParam.matching((String)"(([A-Za-z]{2})/)?").preservePath(true)));
        router.assertRoute(Collections.singletonMap("a", "fr/"), "/fr/b");
        router.assertRoute(Collections.singletonMap("a", ""), "/b");
    }

    @Test
    public void testOptionalParameter() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{a}/b", Collections.singletonMap("a", PathParam.matching((String)"a?").preservePath(true)));
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("a", "a");
        router.assertRoute(a, Collections.singletonMap("a", "a"), "/a/b");
        MatchTestCase.assertEquals((String)"/a/b", (String)a.matches(expectedParameters).render());
        expectedParameters.put("a", "");
        router.assertRoute(expectedParameters, "/b");
        MatchTestCase.assertEquals((String)"/b", (String)a.matches(expectedParameters).render());
    }

    @Test
    public void testAvoidMatchingPrefix() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{a}/ab/c", Collections.singletonMap("a", PathParam.matching((String)"a?").preservePath(true)));
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("a", "");
        router.assertRoute(a, expectedParameters, "/ab/c");
        MatchTestCase.assertEquals((String)"/ab/c", (String)a.matches(expectedParameters).render());
    }

    @Test
    public void testPartialMatching() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/{a}", Collections.singletonMap("a", PathParam.matching((String)"abc").preservePath(true)));
        MatchTestCase.assertNull((Object)router.route("/abcdef"));
    }

    @Test
    public void testZeroOrOneFollowedBySubRoute() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{a}", Collections.singletonMap("a", PathParam.matching((String)"a?").preservePath(true)));
        Route b = a.append("/b");
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("a", "a");
        router.assertRoute(expectedParameters, "/a/b");
        RouteMatch resolve = b.matches(expectedParameters);
        MatchTestCase.assertNotNull((Object)resolve);
        MatchTestCase.assertEquals((String)"/a/b", (String)resolve.render());
        router.assertRoute(b, "/b");
    }

    @Test
    public void testMatcher() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{a}");
        Route b = router.append("/a");
        router.assertRoutes((Iterable<Route>)Arrays.asList(a, b), "/a");
    }

    @Test
    public void testDisjunction() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/{a}{b}", Collections.singletonMap("a", PathParam.matching((String)"a|b")));
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("a", "a");
        expectedParameters.put("b", "c");
        router.assertRoute(expectedParameters, "/ac");
        expectedParameters.put("a", "b");
        router.assertRoute(expectedParameters, "/bc");
    }

    @Test
    public void testCaptureGroup() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/{a}", Collections.singletonMap("a", PathParam.matching((String)"a(.)c").captureGroup(true)));
        router.assertRoute(Collections.singletonMap("a", "b"), "/abc");
    }

    @Test
    public void testPreservePath() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/{a}", Collections.singletonMap("a", PathParam.matching((String)".*").preservePath(true)));
        router.assertRoute(Collections.singletonMap("a", "a"), "/a");
        router.assertRoute(Collections.singletonMap("a", "//"), "///");
        router.assertRoute(Collections.singletonMap("a", "a/"), "/a/");
    }
}

