/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpUtils;
import juzu.impl.common.MimeType;
import juzu.impl.common.URIWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIHelper
implements Appendable {
    private StringBuilder sb;
    final URIWriter writer;

    public URIHelper() {
        this(new StringBuilder());
    }

    public URIHelper(StringBuilder sb) {
        this.sb = sb;
        this.writer = new URIWriter((Appendable)this, MimeType.PLAIN);
    }

    public String getPath() {
        if (this.sb != null) {
            int index = this.sb.indexOf("?");
            if (index != -1) {
                return this.sb.substring(0, index);
            }
            return this.sb.toString();
        }
        return null;
    }

    public Map<String, String[]> getQueryParams() {
        int index;
        if (this.sb != null && (index = this.sb.indexOf("?")) != -1) {
            String query = this.sb.substring(index + 1);
            return HttpUtils.parseQueryString((String)query);
        }
        return null;
    }

    public void reset() {
        if (this.sb != null) {
            this.sb.setLength(0);
        }
        this.writer.reset((Appendable)this.sb);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.sb.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.sb.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.sb.append(c);
        return this;
    }
}

