/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.io.IOException;
import junit.framework.AssertionFailedError;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.RERenderer;
import juzu.impl.router.regex.SyntaxException;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class RegExpRendererTestCase
extends AbstractTestCase {
    static void assertRender(RENode re, String expected) {
        try {
            String rendered = re != null ? ((StringBuilder)RERenderer.render((RENode)re, (Appendable)new StringBuilder())).toString() : "";
            RegExpRendererTestCase.assertEquals((String)expected, (String)rendered);
        }
        catch (IOException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.Disjunction disjunction(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.Disjunction re = parser.parseDisjunction();
            RegExpRendererTestCase.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.Alternative alternative(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.Alternative re = parser.parseAlternative();
            RegExpRendererTestCase.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.Expr expression(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.Expr re = parser.parseExpression();
            RegExpRendererTestCase.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.CharacterClass characterClass(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.CharacterClass re = parser.parseCharacterClass();
            RegExpRendererTestCase.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    @Test
    public void testSimple() {
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.expression("."), ".");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.expression("^"), "^");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.expression("\\."), "\\.");
    }

    @Test
    public void testDisjunction() {
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.disjunction(""), "");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.disjunction("|"), "|");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.disjunction("a|"), "a|");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.disjunction("|a"), "|a");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.disjunction("a|b"), "a|b");
    }

    @Test
    public void testAlternative() {
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.alternative(""), "");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.alternative("ab"), "ab");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.alternative("abc"), "abc");
    }

    @Test
    public void testCharacterClass() {
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.characterClass(""), "");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.characterClass("[a]"), "[a]");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.characterClass("[ab]"), "[ab]");
        RegExpRendererTestCase.assertRender((RENode)RegExpRendererTestCase.characterClass("[.\\]]"), "[\\.\\]]");
    }
}

