/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.processing.Processor;
import javax.inject.Provider;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.Compiler;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.url.URLFileSystem;
import juzu.impl.metamodel.MetaModelProcessor;
import juzu.processor.MainProcessor;
import juzu.test.AbstractTestCase;
import juzu.test.CompileStrategy;
import juzu.test.JavaCompilerProvider;
import juzu.test.JavaFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerAssert<I, O> {
    public static final Provider<MetaModelProcessor> META_MODEL_PROCESSOR_FACTORY = new Provider<MetaModelProcessor>(){

        public MetaModelProcessor get() {
            return new MainProcessor();
        }
    };
    private static WeakHashMap<ClassLoader, URLFileSystem> classPathCache = new WeakHashMap();
    private ClassLoader classLoader;
    private CompileStrategy<I, O> strategy;

    public CompilerAssert(boolean incremental, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput) {
        URLFileSystem classPath = classPathCache.get(Thread.currentThread().getContextClassLoader());
        if (classPath == null) {
            try {
                classPath = new URLFileSystem().add(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader().getParent());
                classPathCache.put(Thread.currentThread().getContextClassLoader(), classPath);
            }
            catch (Exception e) {
                throw AbstractTestCase.failure(e);
            }
        }
        this.strategy = incremental ? new CompileStrategy.Incremental<I, O>((ReadFileSystem<?>)classPath, sourcePath, sourceOutput, classOutput) : new CompileStrategy.Batch<I, O>((ReadFileSystem<?>)classPath, sourcePath, sourceOutput, classOutput);
        this.strategy.processorFactory = META_MODEL_PROCESSOR_FACTORY;
        this.strategy.javaCompilerProvider = JavaCompilerProvider.DEFAULT;
    }

    public CompilerAssert(ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput) {
        this(false, sourcePath, sourceOutput, classOutput);
    }

    public CompilerAssert(ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> output) {
        this(false, sourcePath, output, output);
    }

    public CompilerAssert(boolean incremental, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> output) {
        this(incremental, sourcePath, output, output);
    }

    public CompilerAssert<I, O> with(final Processor processor) {
        this.strategy.processorFactory = new Provider<Processor>(){

            public Processor get() {
                return processor;
            }
        };
        return this;
    }

    public CompilerAssert<I, O> with(Provider<? extends Processor> processorFactory) {
        this.strategy.processorFactory = processorFactory;
        return this;
    }

    public CompilerAssert<I, O> with(JavaCompilerProvider javaCompilerProvider) {
        this.strategy.javaCompilerProvider = javaCompilerProvider;
        return this;
    }

    public CompilerAssert<I, O> addClassPath(ReadFileSystem<?> classPath) {
        this.strategy.addClassPath(classPath);
        return this;
    }

    public ReadFileSystem<I> getSourcePath() {
        return this.strategy.sourcePath;
    }

    public ReadWriteFileSystem<O> getClassOutput() {
        return this.strategy.classOutput;
    }

    public ReadWriteFileSystem<O> getSourceOutput() {
        return this.strategy.sourceOutput;
    }

    public CompilerAssert<I, O> formalErrorReporting(boolean formalErrorReporting) {
        if (formalErrorReporting) {
            this.strategy.config.withProcessorOption("juzu.error_reporting", "formal");
        } else {
            this.strategy.config.withProcessorOption("juzu.error_reporting", null);
        }
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<CompilationError> failCompile() {
        try {
            this.strategy.compile();
            throw AbstractTestCase.failure("Was expecting compilation to fail");
        }
        catch (CompilationException e) {
            return e.getErrors();
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public Compiler assertCompile() {
        try {
            this.strategy.compile();
            this.classLoader = new URLClassLoader(new URL[]{this.strategy.classOutput.getURL()}, Thread.currentThread().getContextClassLoader());
            return this.strategy.compiler;
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public Class<?> assertClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public void assertRemove(String names) {
        try {
            Object path = this.strategy.sourcePath.getPath(new String[]{names});
            if (path == null) {
                throw AbstractTestCase.failure("Cannot remove path " + Tools.join((char)'/', (String[])new String[]{names}));
            }
            this.strategy.sourcePath.removePath(path);
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public JavaFile<I> assertSource(String ... names) {
        Object path;
        try {
            path = this.strategy.sourcePath.getPath(names);
        }
        catch (IOException e) {
            throw AbstractTestCase.failure(e);
        }
        if (path == null) {
            throw AbstractTestCase.failure("Was not expecting " + Arrays.asList(names) + " to be null file");
        }
        return new JavaFile<Object>(this.strategy.sourcePath, path);
    }
}

