/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import java.io.InputStream;
import java.util.List;
import juzu.impl.common.Content;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.test.AbstractTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFile<I> {
    final ReadWriteFileSystem<I> sourcePath;
    final I path;
    private CompilationUnit cu;

    public JavaFile(ReadWriteFileSystem<I> sourcePath, I path) {
        this.sourcePath = sourcePath;
        this.path = path;
        this.cu = null;
    }

    public CompilationUnit assertCompilationUnit() {
        if (this.cu == null) {
            try {
                Content content = (Content)this.sourcePath.getContent(this.path).getObject();
                InputStream in = content.getInputStream();
                this.cu = JavaParser.parse((InputStream)in);
            }
            catch (Exception e) {
                throw AbstractTestCase.failure(e);
            }
        }
        return this.cu;
    }

    public String assertContent() {
        try {
            Content content = (Content)this.sourcePath.getContent(this.path).getObject();
            return content.getCharSequence().toString();
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public ClassOrInterfaceDeclaration assertDeclaration() {
        List decls = this.assertCompilationUnit().getTypes();
        AbstractTestCase.assertEquals((int)1, (int)decls.size());
        TypeDeclaration decl = (TypeDeclaration)decls.get(0);
        return AbstractTestCase.assertInstanceOf(ClassOrInterfaceDeclaration.class, decl);
    }

    public PackageDeclaration assertPackage() {
        return this.assertCompilationUnit().getPackage();
    }

    public void assertTouch() {
        try {
            Content content = (Content)this.sourcePath.getContent(this.path).getObject();
            this.sourcePath.setContent(this.path, content);
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public void assertSave() {
        this.assertSave(this.cu.toString());
    }

    public void assertSave(String content) {
        try {
            this.sourcePath.setContent(this.path, new Content((CharSequence)content));
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }
}

