/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.http;

import java.net.URL;
import java.util.Arrays;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.test.AbstractWebTestCase;
import juzu.test.protocol.http.HttpServletImpl;
import juzu.test.protocol.mock.MockApplication;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpTestCase
extends AbstractWebTestCase {
    private static AbstractHttpTestCase currentTest;
    private MockApplication<?> application;

    public static ApplicationLifeCycle<?, ?> getCurrentApplication() throws IllegalStateException {
        if (currentTest == null) {
            throw new IllegalStateException("No deployed test");
        }
        return AbstractHttpTestCase.currentTest.application.getLifeCycle();
    }

    @Override
    public void setUp() {
        currentTest = this;
    }

    @Override
    public void tearDown() {
        super.tearDown();
        if (this.application != null) {
            this.assertUndeploy();
        }
        currentTest = null;
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        URL descriptor = HttpServletImpl.class.getResource("web.xml");
        URL jquery = HttpServletImpl.class.getResource("jquery-1.7.1.js");
        URL test = HttpServletImpl.class.getResource("test.js");
        URL stylesheet = HttpServletImpl.class.getResource("main.css");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"juzu.war")).addAsWebResource(jquery, "jquery.js")).addAsWebResource(test, "test.js")).addAsWebResource(stylesheet, "main.css")).setWebXML(descriptor);
    }

    public void assertUndeploy() {
        if (this.application == null) {
            throw AbstractHttpTestCase.failure("No application to undeploy");
        }
        MockApplication<?> app = this.application;
        this.application = null;
        app.getLifeCycle().close();
    }

    public final MockApplication<?> assertDeploy(String packageName) {
        try {
            this.application = this.application(InjectorProvider.CDI_WELD, packageName);
            return this.application;
        }
        catch (Exception e) {
            throw AbstractHttpTestCase.failure("Could not deploy application " + Arrays.asList(packageName), e);
        }
    }
}

