/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.Response;
import juzu.asset.Asset;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.Application;
import juzu.io.AppendableStream;
import juzu.io.Stream;
import juzu.test.protocol.http.HttpServletImpl;
import juzu.test.protocol.http.MimeBridgeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderBridgeImpl
extends MimeBridgeImpl
implements RenderBridge {
    private final HttpServletImpl servlet;
    private Response.Content response;
    private Iterable<Asset.Value> scripts;
    private Iterable<Asset.Value> stylesheets;
    private String title;

    RenderBridgeImpl(HttpServletImpl servlet, Application application, HttpServletRequest req, HttpServletResponse resp, MethodHandle target, Map<String, String[]> parameters) {
        super(application, req, resp, target, parameters);
        this.servlet = servlet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setResponse(Response response) throws IllegalStateException, IOException {
        if (response instanceof Response.Content) {
            if (response instanceof Response.Render) {
                Response.Render render = (Response.Render)response;
                try {
                    Iterable scripts = this.servlet.scriptManager.resolveAssets(render.getScripts());
                    Iterable stylesheets = this.servlet.stylesheetManager.resolveAssets(render.getStylesheets());
                    this.scripts = scripts;
                    this.stylesheets = stylesheets;
                }
                catch (IllegalArgumentException e) {
                    response = Response.content((int)500, (CharSequence)e.getMessage());
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.response = (Response.Content)response;
    }

    private void renderAssetURL(Asset.Value asset, Appendable appendable) throws IOException {
        String uri = asset.getURI();
        switch (asset.getLocation()) {
            case SERVER: {
                if (!uri.startsWith("/")) {
                    appendable.append(this.req.getContextPath());
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case CLASSPATH: {
                appendable.append(this.req.getContextPath());
                if (!uri.startsWith("/")) {
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
            }
        }
    }

    @Override
    public void end() {
        super.end();
        ScopedContext context = this.getFlashContext(false);
        if (context != null) {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.response != null) {
            Integer status = this.response.getStatus();
            if (status != null) {
                this.resp.setStatus(status.intValue());
            }
            PrintWriter writer = null;
            try {
                writer = this.resp.getWriter();
                writer.println("<!DOCTYPE html>");
                writer.println("<html>");
                if (this.response instanceof Response.Render) {
                    writer.println("<head>");
                    for (Asset.Value stylesheet : this.stylesheets) {
                        String path = stylesheet.getURI();
                        int pos = path.lastIndexOf(46);
                        String ext = pos == -1 ? "css" : path.substring(pos + 1);
                        writer.print("<link rel=\"stylesheet\" type=\"text/");
                        writer.print(ext);
                        writer.print("\" href=\"");
                        this.renderAssetURL(stylesheet, writer);
                        writer.println("\"></link>");
                    }
                    for (Asset.Value script : this.scripts) {
                        writer.print("<script type=\"text/javascript\" src=\"");
                        this.renderAssetURL(script, writer);
                        writer.println("\"></script>");
                    }
                    writer.println("</head>");
                }
                this.resp.setContentType(this.response.getMimeType());
                writer.println("<body>");
                this.response.send((Stream)new AppendableStream((Appendable)writer));
                writer.println("</body>");
                writer.println("</html>");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Tools.safeClose((Closeable)writer);
            }
        }
    }
}

