/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.impl.bridge.spi.DispatchSPI;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.common.JSON;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.impl.common.Tools;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Argument;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.request.Phase;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockHttpContext;
import juzu.test.protocol.mock.MockSecurityContext;
import juzu.test.protocol.mock.MockWindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockRequestBridge
implements RequestBridge {
    protected final Application application;
    protected final MockClient client;
    private final MethodHandle target;
    private final Map<String, String[]> parameters;
    private final ScopedContext attributes;
    private final MockHttpContext httpContext;
    private final MockSecurityContext securityContext;
    private final MockWindowContext windowContext;
    private final List<Scoped> attributesHistory;
    private final Map<String, ? extends Argument> arguments;

    public MockRequestBridge(Application application, MockClient client, MethodHandle target, Map<String, String[]> parameters) {
        Method descriptor = application.getDescriptor().getControllers().getMethodByHandle(target);
        Map arguments = descriptor.getArguments(parameters);
        this.application = application;
        this.client = client;
        this.target = target;
        this.parameters = parameters;
        this.attributes = new ScopedContext();
        this.httpContext = new MockHttpContext();
        this.securityContext = new MockSecurityContext();
        this.windowContext = new MockWindowContext();
        this.attributesHistory = new ArrayList<Scoped>();
        this.arguments = arguments;
    }

    public Map<String, ? extends Argument> getArguments() {
        return this.arguments;
    }

    public List<Scoped> getAttributesHistory() {
        return this.attributesHistory;
    }

    public MethodHandle getTarget() {
        return this.target;
    }

    public <T> T getProperty(PropertyType<T> propertyType) {
        return null;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public Scoped getFlashValue(Object key) {
        return this.client.getFlashValue(key);
    }

    public void setFlashValue(Object key, Scoped value) {
        this.client.setFlashValue(key, value);
    }

    public Scoped getRequestValue(Object key) {
        return this.attributes.get(key);
    }

    public void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            this.attributes.set(key, value);
        } else {
            this.attributes.set(key, null);
        }
    }

    public Scoped getSessionValue(Object key) {
        return this.client.getSession().get(key);
    }

    public void setSessionValue(Object key, Scoped value) {
        if (value != null) {
            this.client.getSession().set(key, value);
        } else {
            this.client.getSession().set(key, null);
        }
    }

    public void purgeSession() {
        throw new UnsupportedOperationException();
    }

    public Scoped getIdentityValue(Object key) {
        return null;
    }

    public void setIdentityValue(Object key, Scoped value) {
    }

    public MockSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public MockHttpContext getHttpContext() {
        return this.httpContext;
    }

    public MockWindowContext getWindowContext() {
        return this.windowContext;
    }

    public void close() {
    }

    public String _checkPropertyValidity(Phase phase, PropertyType<?> propertyType, Object propertyValue) {
        if (propertyType == PropertyType.ESCAPE_XML) {
            return null;
        }
        return "Unsupported property " + propertyType + " = " + propertyValue;
    }

    public final DispatchSPI createDispatch(final Phase phase, final MethodHandle target, final Map<String, String[]> parameters) throws NullPointerException, IllegalArgumentException {
        return new DispatchSPI(){

            public MethodHandle getTarget() {
                return target;
            }

            public Map<String, String[]> getParameters() {
                return parameters;
            }

            public <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue) {
                return MockRequestBridge.this._checkPropertyValidity(phase, propertyType, propertyValue);
            }

            public void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException {
                Method method = MockRequestBridge.this.application.getDescriptor().getControllers().getMethodByHandle(target);
                JSON props = new JSON();
                if (properties != null) {
                    for (PropertyType property : properties) {
                        Object value = properties.getValue(property);
                        String valid = MockRequestBridge.this._checkPropertyValidity(method.getPhase(), property, value);
                        if (valid != null) {
                            throw new IllegalArgumentException(valid);
                        }
                        props.set(property.getClass().getName(), value);
                    }
                }
                JSON url = new JSON();
                url.set("target", (Object)target.toString());
                url.map("parameters", parameters);
                url.set("properties", (Object)props);
                url.toString(appendable);
            }
        };
    }

    public void begin(Request request) {
    }

    public void end() {
        this.attributesHistory.addAll(Tools.list((Iterable)this.attributes));
        this.attributes.close();
    }
}

