/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.portlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.WindowState;
import juzu.Consumes;
import juzu.PropertyType;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.spi.portlet.PortletActionBridge;
import juzu.impl.bridge.spi.portlet.PortletEventBridge;
import juzu.impl.bridge.spi.portlet.PortletRenderBridge;
import juzu.impl.bridge.spi.portlet.PortletResourceBridge;
import juzu.impl.common.DevClassLoader;
import juzu.impl.common.Logger;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.request.Method;
import juzu.impl.resource.ResourceResolver;
import juzu.request.Phase;

public class JuzuPortlet
implements Portlet,
ResourceServingPortlet,
EventPortlet {
    public static final PropertyType<PortletMode> PORTLET_MODE = new PropertyType<PortletMode>(){};
    public static final PropertyType<WindowState> WINDOW_STATE = new PropertyType<WindowState>(){};
    private BridgeConfig bridgeConfig;
    private Bridge bridge;
    private PortletContext context;
    private boolean initialized = false;

    public void init(final PortletConfig config) throws PortletException {
        ModuleLifeCycle module;
        BridgeConfig bridgeConfig;
        Logger log = new Logger(){

            public void log(CharSequence msg) {
                System.out.println("[" + config.getPortletName() + "] " + msg);
            }

            public void log(CharSequence msg, Throwable t) {
                System.err.println("[" + config.getPortletName() + "] " + msg);
                t.printStackTrace();
            }
        };
        AssetServer server = (AssetServer)config.getPortletContext().getAttribute("asset.server");
        if (server == null) {
            server = new AssetServer();
            config.getPortletContext().setAttribute("asset.server", (Object)server);
        }
        try {
            bridgeConfig = new BridgeConfig((Map<String, String>)new SimpleMap<String, String>(){

                @Override
                protected Iterator<String> keys() {
                    return BridgeConfig.NAMES.iterator();
                }

                @Override
                public String get(Object key) {
                    if ("juzu.app_name".equals(key)) {
                        return JuzuPortlet.this.getApplicationName(config);
                    }
                    if ("juzu.run_mode".equals(key)) {
                        return JuzuPortlet.this.getRunMode(config);
                    }
                    if (BridgeConfig.NAMES.contains(key)) {
                        return config.getInitParameter((String)key);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String msg = "Could not find an application to start";
            if (e instanceof PortletException) {
                String nested = e.getMessage();
                if (nested != null) {
                    msg = msg + ":" + nested;
                }
                throw new PortletException(msg, e.getCause());
            }
            throw new PortletException(msg, (Throwable)e);
        }
        String srcPath = config.getInitParameter("juzu.src_path");
        ReadFileSystem sourcePath = srcPath != null ? new DiskFileSystem(new File(srcPath)) : WarFileSystem.create(config.getPortletContext(), "/WEB-INF/src/");
        switch (bridgeConfig.runMode) {
            case 1: {
                module = new ModuleLifeCycle.Dynamic<File>(log, new DevClassLoader(Thread.currentThread().getContextClassLoader()), sourcePath);
                break;
            }
            default: {
                module = new ModuleLifeCycle.Static<String>(log, Thread.currentThread().getContextClassLoader(), WarFileSystem.create(config.getPortletContext(), "/WEB-INF/classes/"));
            }
        }
        Bridge bridge = new Bridge(log, module, bridgeConfig, WarFileSystem.create(config.getPortletContext(), "/WEB-INF/"), server, new ResourceResolver(){

            public URL resolve(String uri) {
                try {
                    return JuzuPortlet.this.context.getResource(uri);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        this.bridgeConfig = bridgeConfig;
        this.bridge = bridge;
        this.context = config.getPortletContext();
    }

    protected String getApplicationName(PortletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    protected String getRunMode(PortletConfig config) {
        return config.getInitParameter("juzu.run_mode");
    }

    private void rethrow(Throwable e) throws PortletException, IOException {
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new PortletException(e);
    }

    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        try {
            PortletActionBridge requestBridge = new PortletActionBridge(this.bridge.application.getApplication(), req, resp, this.bridge.getConfig().isProd());
            this.bridge.processAction(requestBridge);
            requestBridge.send();
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        ControllerResolver<Method> resolver = this.bridge.application.getApplication().getDescriptor().getControllers().getResolver();
        List<Method> methods = resolver.resolveMethods(Phase.EVENT, null, request.getParameterMap().keySet());
        Method target = null;
        for (Method method : methods) {
            Consumes consumes = method.getMethod().getAnnotation(Consumes.class);
            if (consumes.value().equals("")) {
                target = method;
                continue;
            }
            if (!consumes.value().equals(request.getEvent().getName())) continue;
            target = method;
            break;
        }
        if (target != null) {
            try {
                PortletEventBridge requestBridge = new PortletEventBridge(this.bridge.application.getApplication(), request, response, target, (Map<String, String[]>)request.getParameterMap(), this.bridge.getConfig().isProd());
                this.bridge.processEvent(requestBridge);
                requestBridge.send();
            }
            catch (Throwable e) {
                this.rethrow(e);
            }
        } else {
            response.setRenderParameters(request);
        }
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        if (!this.initialized) {
            try {
                this.bridge.refresh();
                this.initialized = true;
            }
            catch (Exception e) {
                String msg = "Could not compile application";
                if (e instanceof PortletException) {
                    String nested = e.getMessage();
                    if (nested != null) {
                        msg = msg + ":" + nested;
                    }
                    throw new PortletException(msg, e.getCause());
                }
                throw new PortletException(msg, (Throwable)e);
            }
        }
        try {
            PortletRenderBridge requestBridge = new PortletRenderBridge(this.bridge.application.getApplication(), this.bridge, req, resp, this.bridge.getConfig().isProd());
            this.bridge.render(requestBridge);
            requestBridge.send();
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    public void serveResource(ResourceRequest req, ResourceResponse resp) throws PortletException, IOException {
        boolean assetRequest = "assets".equals(req.getParameter("juzu.request"));
        if (assetRequest && !this.bridgeConfig.isProd()) {
            InputStream in;
            String contentType;
            String path = req.getResourceID();
            URL url = this.bridge.application.getScriptManager().resolveAsset(path);
            if (url != null) {
                contentType = "text/javascript";
                in = url.openStream();
            } else {
                contentType = null;
                in = null;
            }
            if (in == null && (url = this.bridge.application.getStylesheetManager().resolveAsset(path)) != null) {
                contentType = "text/css";
                in = this.bridge.application.getApplication().getClassLoader().getResourceAsStream(path.substring(1));
            }
            if (in != null) {
                resp.setContentType(contentType);
                Tools.copy(in, resp.getPortletOutputStream());
            } else {
                resp.addProperty("portlet.http-status-code", "404");
            }
        } else {
            try {
                PortletResourceBridge requestBridge = new PortletResourceBridge(this.bridge.application.getApplication(), req, resp, this.bridge.getConfig().isProd());
                this.bridge.serveResource(requestBridge);
                requestBridge.send();
            }
            catch (Throwable throwable) {
                this.rethrow(throwable);
            }
        }
    }

    public void destroy() {
        Tools.safeClose(this.bridge);
    }
}

