/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.Asset;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.servlet.Handler;
import juzu.impl.bridge.spi.servlet.ServletMimeBridge;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Method;
import juzu.io.AppendableStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRenderBridge
extends ServletMimeBridge
implements RenderBridge {
    private Response.Content response;
    private Iterable<Asset.Value> scripts;
    private Iterable<Asset.Value> stylesheets;
    private Map<String, String> responseMetaTags;
    private String title;

    ServletRenderBridge(Application application, Handler handler, HttpServletRequest req, HttpServletResponse resp, Method<?> target, Map<String, String[]> parameters) {
        super(application, handler, req, resp, target, parameters);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (response instanceof Response.Content) {
            Response.Content content = response;
            try {
                PropertyMap properties = response.getProperties();
                Iterable<Map.Entry<String, String>> metaProps = properties.getValues(PropertyType.META_TAG);
                Iterable<Asset> scriptsProp = properties.getValues(PropertyType.SCRIPT);
                Iterable<Asset> stylesheetProps = properties.getValues(PropertyType.STYLESHEET);
                Map<String, String> metaTags = Collections.emptyMap();
                if (metaProps != null) {
                    for (Map.Entry<String, String> entry : metaProps) {
                        if (metaTags.isEmpty()) {
                            metaTags = new HashMap();
                        }
                        metaTags.put(entry.getKey(), entry.getValue());
                    }
                }
                Iterable<Object> stylesheets = Collections.emptyList();
                if (stylesheetProps != null) {
                    stylesheets = this.handler.bridge.application.getStylesheetManager().resolveAssets(stylesheetProps);
                }
                Iterable<Object> scripts = Collections.emptyList();
                if (scriptsProp != null) {
                    scripts = this.handler.bridge.application.getScriptManager().resolveAssets(scriptsProp);
                }
                this.scripts = scripts;
                this.stylesheets = stylesheets;
                this.responseMetaTags = metaTags;
            }
            catch (IllegalArgumentException e) {
                response = Response.content(500, e.getMessage());
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.response = response;
    }

    private String getAssetURL(Asset.Value asset) {
        String url;
        String uri = asset.getURI();
        switch (asset.getLocation()) {
            case SERVER: {
                StringBuilder sb = new StringBuilder();
                if (!uri.startsWith("/")) {
                    sb.append(this.req.getContextPath());
                    sb.append('/');
                }
                sb.append(uri);
                url = sb.toString();
                break;
            }
            case CLASSPATH: {
                if (this.handler.bridge.getConfig().isProd()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.req.getContextPath()).append("/assets");
                    if (!uri.startsWith("/")) {
                        sb.append('/');
                    }
                    sb.append(uri);
                    url = sb.toString();
                    break;
                }
                throw new UnsupportedOperationException("not yet done");
            }
            case URL: {
                url = uri;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return url;
    }

    @Override
    public void end() {
        super.end();
        ScopedContext context = this.getFlashContext(false);
        if (context != null) {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void send() throws IOException {
        if (this.response != null) {
            this.resp.setContentType(this.response.getMimeType());
            Integer status = this.response.getStatus();
            if (status != null) {
                this.resp.setStatus(status.intValue());
            }
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                this.resp.setHeader((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            PrintWriter writer = null;
            try {
                writer = this.resp.getWriter();
                writer.println("<!DOCTYPE html>");
                writer.println("<html>");
                writer.println("<head>");
                if (this.title != null) {
                    writer.print("<title>");
                    writer.print(this.title);
                    writer.println("</title>");
                }
                for (Map.Entry<String, String> meta : this.responseMetaTags.entrySet()) {
                    writer.print("<meta name=\"");
                    writer.append(meta.getKey());
                    writer.append("\" content=\"");
                    writer.append(meta.getValue());
                    writer.println("\">");
                }
                for (Asset.Value stylesheet : this.stylesheets) {
                    String path = stylesheet.getURI();
                    int pos = path.lastIndexOf(46);
                    String ext = pos == -1 ? "css" : path.substring(pos + 1);
                    writer.print("<link rel=\"stylesheet\" type=\"text/");
                    writer.print(ext);
                    writer.print("\" href=\"");
                    writer.append(this.getAssetURL(stylesheet));
                    writer.println("\"></link>");
                }
                for (Asset.Value script : this.scripts) {
                    writer.print("<script type=\"text/javascript\" src=\"");
                    writer.append(this.getAssetURL(script));
                    writer.println("\"></script>");
                }
                writer.println("</head>");
                writer.println("<body>");
                this.response.send(new AppendableStream(writer));
                writer.println("</body>");
                writer.println("</html>");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                Tools.safeClose(writer);
                throw throwable;
            }
            Tools.safeClose(writer);
            {
            }
        }
    }
}

